/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import joshie.harvest.animals.entity.EntityAIEat;
import joshie.harvest.animals.entity.EntityAILayEgg;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityHarvestChicken
extends EntityChicken
implements IAnimalTracked<EntityHarvestChicken> {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private final IAnimalData data;
    private EntityPlayer toLovePlayer;
    private int toLoveTicker;

    public EntityHarvestChicken(World world) {
        super(world);
        this.field_70887_j = Integer.MAX_VALUE;
        this.data = HFApi.animals.newData(this, "chicken");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEat(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILayEgg(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0, true, false));
        return super.func_70097_a(source, amount);
    }

    @Override
    public IAnimalData getData() {
        return this.data;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null) {
            if (HFApi.animals.canEat(stack, this.data.getType().getFoodTypes())) {
                if (this.data.isHungry()) {
                    stack.func_77979_a(1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.data.feed(player);
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public EntityHarvestChicken createChild(EntityAgeable ageable) {
        return new EntityHarvestChicken(this.field_70170_p);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.toLovePlayer != null) {
            if (this.toLoveTicker >= 0) {
                --this.toLoveTicker;
            } else {
                ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(this.toLovePlayer)).getRelationships().talkTo(this.toLovePlayer, this.getUUID());
                this.toLovePlayer = null;
            }
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.toLovePlayer = player;
        this.toLoveTicker = 20;
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.data.toBytes(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.data.fromBytes(buffer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.data.readFromNBT(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.data.writeToNBT(nbt);
    }
}

