/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import joshie.harvest.animals.tile.TileTrough;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.animals.IAnimalFeeder;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.base.block.BlockHFEnumRotatableMeta;
import joshie.harvest.core.base.tile.TileFillable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrough
extends BlockHFEnumRotatableMeta<BlockTrough, Trough>
implements IAnimalFeeder {
    private static final AxisAlignedBB TROUGH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final PropertyEnum<Section> SECTION = PropertyEnum.func_177709_a((String)"section", Section.class);

    public BlockTrough() {
        super(Material.field_151575_d, Trough.class);
        this.setHardness(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a(SECTION, (Comparable)((Object)Section.SINGLE_EMPTY)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, FACING, SECTION});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FACING, SECTION});
    }

    @Override
    public String getToolType(Trough wood) {
        return "axe";
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TROUGH_AABB);
        } else {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HFCore.FENCE_COLLISION);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TROUGH_AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player.func_70093_af()) {
            return false;
        }
        if (held != null && (tile = world.func_175625_s(pos)) instanceof TileFillable) {
            return ((TileFillable)tile).onActivated(held);
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        Trough trough = (Trough)((Object)this.getEnumFromState(state));
        switch (trough) {
            case WOOD: {
                return new TileTrough();
            }
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTrough) {
            boolean isFilled = ((TileTrough)tile).getMaster().getFillAmount() > 0;
            boolean north = this.isTrough(EnumFacing.NORTH, world, pos);
            boolean south = this.isTrough(EnumFacing.SOUTH, world, pos);
            if (north && !south) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.END_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST) : state.func_177226_a(SECTION, (Comparable)((Object)Section.END_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            if (south && !north) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.END_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST) : state.func_177226_a(SECTION, (Comparable)((Object)Section.END_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            if (south && north) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.MIDDLE_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST) : state.func_177226_a(SECTION, (Comparable)((Object)Section.MIDDLE_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            boolean east = this.isTrough(EnumFacing.EAST, world, pos);
            boolean west = this.isTrough(EnumFacing.WEST, world, pos);
            if (west && east) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.MIDDLE_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH) : state.func_177226_a(SECTION, (Comparable)((Object)Section.MIDDLE_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            if (east && !west) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.END_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH) : state.func_177226_a(SECTION, (Comparable)((Object)Section.END_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            if (west && !east) {
                return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.END_FILLED)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH) : state.func_177226_a(SECTION, (Comparable)((Object)Section.END_EMPTY)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            return isFilled ? state.func_177226_a(SECTION, (Comparable)((Object)Section.SINGLE_FILLED)) : state.func_177226_a(SECTION, (Comparable)((Object)Section.SINGLE_EMPTY));
        }
        return state;
    }

    private boolean isTrough(EnumFacing facing, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        if (state.func_177230_c() == this && this.getEnumFromState(state) == Trough.WOOD) {
            return ((TileTrough)world.func_175625_s(pos)).getMaster() == ((TileTrough)world.func_175625_s(pos.func_177972_a(facing))).getMaster();
        }
        return false;
    }

    @Override
    public boolean feedAnimal(IAnimalTracked tracked, World world, BlockPos pos, IBlockState state) {
        TileTrough master;
        if (HFApi.animals.canAnimalEatFoodType(tracked, AnimalFoodType.GRASS) && (master = ((TileTrough)world.func_175625_s(pos)).getMaster()).getFillAmount() > 0) {
            master.adjustFill(-1);
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (this.getEnumFromState(state) == Trough.WOOD) {
            ((TileTrough)world.func_175625_s(pos)).onPlaced();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.getEnumFromState(state) == Trough.WOOD) {
            ((TileTrough)world.func_175625_s(pos)).onRemoved();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((Trough[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "facing=north,section=single_filled," + this.property.func_177701_a() + "=" + ((Trough)((Object)this.getEnumFromMeta(i))).func_176610_l()));
        }
    }

    public static enum Section implements IStringSerializable
    {
        SINGLE_EMPTY,
        SINGLE_FILLED,
        END_EMPTY,
        END_FILLED,
        MIDDLE_EMPTY,
        MIDDLE_FILLED;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum Trough implements IStringSerializable
    {
        WOOD;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

