/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.entity.EntityHarvestChicken;
import joshie.harvest.animals.tile.TileFeeder;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.animals.IAnimalFeeder;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.INest;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.base.tile.TileFillable;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTray
extends BlockHFEnum<BlockTray, Tray>
implements IAnimalFeeder,
INest {
    private static final AxisAlignedBB NEST_AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.35, 0.85);
    private static final AxisAlignedBB FEEDER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.075, 1.0);

    public BlockTray() {
        super(Material.field_151575_d, Tray.class);
        this.setHardness(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public String getToolType(Tray wood) {
        return "axe";
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        if (entityIn instanceof EntityPlayer || entityIn instanceof EntityItem) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn);
        } else {
            BlockTray.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HFCore.FENCE_COLLISION);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Tray)((Object)this.getEnumFromState(state))).isFeeder() ? FEEDER_AABB : NEST_AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (held == null) {
            Tray nest = (Tray)((Object)this.getEnumFromState(state));
            if (nest.getDrop() != null) {
                if (!world.field_72995_K) {
                    ItemStack drop = nest.getDrop();
                    List<EntityHarvestChicken> chickens = EntityHelper.getEntities(EntityHarvestChicken.class, world, pos, 32.0, 8.0);
                    int relationship = chickens.size() > 0 ? HFApi.relationships.getRelationship(player, chickens.get(0).getUUID()) : 0;
                    NBTTagCompound tag = drop.func_179543_a("Data", true);
                    tag.func_74768_a("Relationship", relationship);
                    tag.func_74778_a("Owner", EntityHelper.getPlayerUUID(player).toString());
                    SpawnItemHelper.addToPlayerInventory(player, drop);
                    world.func_175656_a(pos, this.getStateFromEnum(Tray.NEST_EMPTY));
                    player.func_71029_a((StatBase)HFAchievements.egger);
                    if (HFCore.SIZEABLE.getSize(drop) == ISizeable.Size.LARGE) {
                        player.func_71029_a((StatBase)HFAchievements.eggerLarge);
                    }
                }
                return true;
            }
        } else {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFillable) {
                return ((TileFillable)tile).onActivated(held);
            }
        }
        return false;
    }

    @Override
    public boolean feedAnimal(IAnimalTracked tracked, World world, BlockPos pos, IBlockState state) {
        TileFeeder feeder;
        if (((Tray)((Object)this.getEnumFromState(state))).isFeeder() && HFApi.animals.canAnimalEatFoodType(tracked, AnimalFoodType.SEED) && (feeder = (TileFeeder)world.func_175625_s(pos)).getFillAmount() > 0) {
            feeder.adjustFill(-1);
            tracked.getData().feed(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean layEgg(IAnimalTracked tracked, World world, BlockPos pos, IBlockState state) {
        EntityPlayer player = tracked.getData().getOwner();
        if (player != null && this.getEnumFromState(state) == Tray.NEST_EMPTY && tracked.getData().getType().getName().equals("chicken")) {
            ISizeable.Size size = null;
            int relationship = HFApi.relationships.getRelationship(player, tracked.getUUID());
            for (ISizeable.Size s : ISizeable.Size.values()) {
                if (relationship < s.getRelationshipRequirement() / 5) continue;
                size = s;
            }
            if (size == ISizeable.Size.SMALL) {
                world.func_175656_a(pos, this.getStateFromEnum(Tray.SMALL_CHICKEN));
            } else if (size == ISizeable.Size.MEDIUM) {
                world.func_175656_a(pos, this.getStateFromEnum(Tray.MEDIUM_CHICKEN));
            } else if (size == ISizeable.Size.LARGE) {
                world.func_175656_a(pos, this.getStateFromEnum(Tray.LARGE_CHICKEN));
            }
            Object entity = tracked.getAsEntity();
            tracked.getData().setProduced(1);
            entity.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (((EntityAnimal)entity).field_70170_p.field_73012_v.nextFloat() - ((EntityAnimal)entity).field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return ((Tray)((Object)this.getEnumFromState(state))).isFeeder();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((Tray)((Object)this.getEnumFromState(state))).isFeeder() ? new TileFeeder() : null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFeeder) {
            boolean isFilled;
            boolean bl = isFilled = ((TileFeeder)tile).getFillAmount() > 0;
            if (isFilled) {
                return this.getStateFromEnum(Tray.FEEDER_FULL);
            }
            return this.getStateFromEnum(Tray.FEEDER_EMPTY);
        }
        return state;
    }

    @Override
    protected boolean shouldDisplayInCreative(Tray tray) {
        return true;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 10;
    }

    public static enum Tray implements IStringSerializable
    {
        NEST_EMPTY,
        SMALL_CHICKEN,
        MEDIUM_CHICKEN,
        LARGE_CHICKEN,
        FEEDER_EMPTY,
        FEEDER_FULL;


        public ItemStack getDrop() {
            if (this == SMALL_CHICKEN) {
                return HFAnimals.EGG.getStack(ISizeable.Size.SMALL);
            }
            if (this == MEDIUM_CHICKEN) {
                return HFAnimals.EGG.getStack(ISizeable.Size.MEDIUM);
            }
            if (this == LARGE_CHICKEN) {
                return HFAnimals.EGG.getStack(ISizeable.Size.LARGE);
            }
            return null;
        }

        public boolean isEmpty() {
            return this == NEST_EMPTY || this == FEEDER_EMPTY;
        }

        public boolean isFeeder() {
            return this == FEEDER_EMPTY || this == FEEDER_FULL;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

