/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.block;

import java.util.Locale;
import joshie.harvest.animals.tile.TileIncubator;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.base.block.BlockHFEnumRotatableTile;
import joshie.harvest.core.base.tile.TileFillableSized;
import joshie.harvest.core.util.IFaceable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSizedStorage
extends BlockHFEnumRotatableTile<BlockSizedStorage, SizedStorage> {
    private static final AxisAlignedBB NEST_NORTH_AABB = new AxisAlignedBB(0.05, 0.0, 0.3, 0.95, 0.7, 0.95);
    private static final AxisAlignedBB NEST_SOUTH_AABB = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.7, 0.7);
    private static final AxisAlignedBB NEST_WEST_AABB = new AxisAlignedBB(0.3, 0.0, 0.05, 0.95, 0.7, 0.95);
    private static final AxisAlignedBB NEST_EAST_AABB = new AxisAlignedBB(0.05, 0.0, 0.05, 0.7, 0.7, 0.95);
    public static final PropertyEnum<Fill> FILL = PropertyEnum.func_177709_a((String)"fill", Fill.class);

    public BlockSizedStorage() {
        super(Material.field_151575_d, SizedStorage.class);
        this.setHardness(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a(FILL, (Comparable)((Object)Fill.EMPTY)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, FACING, FILL});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FACING, FILL});
    }

    @Override
    public String getToolType(SizedStorage wood) {
        return "axe";
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IFaceable) {
            switch (((IFaceable)tile).getFacing()) {
                case NORTH: {
                    return NEST_NORTH_AABB;
                }
                case SOUTH: {
                    return NEST_SOUTH_AABB;
                }
                case WEST: {
                    return NEST_WEST_AABB;
                }
                case EAST: {
                    return NEST_EAST_AABB;
                }
            }
            return field_185505_j;
        }
        return field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player.func_70093_af()) {
            return false;
        }
        if (held != null && (tile = world.func_175625_s(pos)) instanceof TileFillableSized) {
            return ((TileFillableSized)tile).onActivated(player, held);
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileIncubator();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileFillableSized tile = (TileFillableSized)world.func_175625_s(pos);
        boolean isFilled = tile.getFillAmount() > 0;
        IBlockState theState = isFilled ? state.func_177226_a(FILL, (Comparable)((Object)Fill.getFillFromSize(tile.getSize()))) : state.func_177226_a(FILL, (Comparable)((Object)Fill.EMPTY));
        return super.func_176221_a(theState, world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((SizedStorage[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "facing=north,fill=empty," + this.property.func_177701_a() + "=" + ((SizedStorage)((Object)this.getEnumFromMeta(i))).func_176610_l()));
        }
    }

    public static enum Fill implements IStringSerializable
    {
        EMPTY,
        SMALL,
        MEDIUM,
        LARGE;


        public static Fill getFillFromSize(ISizeable.Size size) {
            return size == ISizeable.Size.SMALL ? SMALL : (size == ISizeable.Size.MEDIUM ? MEDIUM : LARGE);
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum SizedStorage implements IStringSerializable
    {
        INCUBATOR;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

