/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals;

import joshie.harvest.HarvestFestival;
import joshie.harvest.animals.AnimalRegistry;
import joshie.harvest.animals.block.BlockSizedStorage;
import joshie.harvest.animals.block.BlockTray;
import joshie.harvest.animals.block.BlockTrough;
import joshie.harvest.animals.entity.EntityHarvestChicken;
import joshie.harvest.animals.entity.EntityHarvestCow;
import joshie.harvest.animals.entity.EntityHarvestSheep;
import joshie.harvest.animals.item.ItemAnimalSpawner;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.animals.item.ItemAnimalTreat;
import joshie.harvest.animals.render.AnimalItemRenderer;
import joshie.harvest.animals.render.ModelHarvestChicken;
import joshie.harvest.animals.render.ModelHarvestCow;
import joshie.harvest.animals.render.ModelHarvestSheep;
import joshie.harvest.animals.render.RenderHarvestChicken;
import joshie.harvest.animals.render.RenderHarvestCow;
import joshie.harvest.animals.render.RenderHarvestSheep;
import joshie.harvest.animals.render.RenderVanillaChicken;
import joshie.harvest.animals.render.RenderVanillaCow;
import joshie.harvest.animals.render.RenderVanillaSheep;
import joshie.harvest.animals.tile.TileFeeder;
import joshie.harvest.animals.tile.TileIncubator;
import joshie.harvest.animals.tile.TileTrough;
import joshie.harvest.animals.type.AnimalChicken;
import joshie.harvest.animals.type.AnimalCow;
import joshie.harvest.animals.type.AnimalSheep;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.core.handlers.SizeableRegistry;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.lib.Sizeable;
import joshie.harvest.core.util.HFLoader;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelSheep2;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFLoader
public class HFAnimals {
    public static final ItemAnimalSpawner ANIMAL = (ItemAnimalSpawner)new ItemAnimalSpawner().register("animal");
    public static final ItemAnimalTool TOOLS = (ItemAnimalTool)new ItemAnimalTool().register("tool_animal");
    public static final ItemAnimalTreat TREATS = (ItemAnimalTreat)new ItemAnimalTreat().register("treat");
    public static final BlockTrough TROUGH = (BlockTrough)new BlockTrough().register("trough");
    public static final BlockSizedStorage SIZED = (BlockSizedStorage)((Object)new BlockSizedStorage().register("sized"));
    public static final BlockTray TRAY = (BlockTray)new BlockTray().register("tray");
    public static final Sizeable EGG = SizeableRegistry.INSTANCE.registerSizeable("egg", 50L, 60L, 80L);
    public static final Sizeable MILK = SizeableRegistry.INSTANCE.registerSizeable("milk", 100L, 150L, 200L);
    public static final Sizeable MAYONNAISE = SizeableRegistry.INSTANCE.registerSizeable("mayonnaise", 300L, 400L, 500L);
    public static final Sizeable WOOL = SizeableRegistry.INSTANCE.registerSizeable("wool", 100L, 400L, 500L);
    public static boolean CAN_SPAWN;
    public static boolean DISABLE_SPAWN_CHICKEN;
    public static boolean PICKUP_CHICKENS;
    public static int MAX_LITTER_SIZE;
    public static int LITTER_EXTRA_CHANCE;
    public static int AGING_TIMER;
    public static int PREGNANCY_TIMER;
    public static int CHICKEN_TIMER;
    public static boolean OP_ANIMALS;
    public static boolean VANILLA_MODELS;

    public static void preInit() {
        EntityRegistry.registerModEntity(EntityHarvestCow.class, (String)"cow", (int)3, (Object)HarvestFestival.instance, (int)150, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityHarvestSheep.class, (String)"sheep", (int)4, (Object)HarvestFestival.instance, (int)150, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityHarvestChicken.class, (String)"chicken", (int)5, (Object)HarvestFestival.instance, (int)150, (int)3, (boolean)true);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.CHICKEN, Items.field_151076_bf, Items.field_151077_bg);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.FISH, Items.field_151115_aP, Items.field_179566_aV);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.FRUIT, Items.field_151034_e, Items.field_151127_ba);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.GRASS, Items.field_151015_O);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.REDMEAT, Items.field_151147_al, Items.field_151082_bd, Items.field_151157_am, Items.field_151083_be);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.SEED, Items.field_151081_bc, Items.field_151014_N, Items.field_151080_bb);
        AnimalRegistry.registerFoodsAsType(AnimalFoodType.VEGETABLE, Items.field_151172_bF);
        HFApi.animals.registerFoodAsType(TOOLS.getStackFromEnum(ItemAnimalTool.Tool.CHICKEN_FEED), AnimalFoodType.SEED);
        HFApi.animals.registerType("cow", new AnimalCow());
        HFApi.animals.registerType("sheep", new AnimalSheep());
        HFApi.animals.registerType("chicken", new AnimalChicken());
        RegistryHelper.registerTiles(TileIncubator.class, TileTrough.class, TileFeeder.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        RegistryHelper.registerEntityRenderer(ANIMAL, AnimalItemRenderer.INSTANCE);
        if (!VANILLA_MODELS) {
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.COW, "cow_adult", (ModelBase)new ModelHarvestCow.Adult());
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.SHEEP, "sheep_adult", (ModelBase)new ModelHarvestSheep.Wooly());
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.CHICKEN, "chicken_adult", (ModelBase)new ModelHarvestChicken.Adult());
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestCow.class, RenderHarvestCow::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestSheep.class, RenderHarvestSheep::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestChicken.class, RenderHarvestChicken::new);
        } else {
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.COW, new ResourceLocation("textures/entity/cow/cow.png"), (ModelBase)new ModelCow());
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.SHEEP, new ResourceLocation("textures/entity/sheep/sheep.png"), (ModelBase)new ModelSheep2());
            AnimalItemRenderer.INSTANCE.register(ItemAnimalSpawner.Spawner.CHICKEN, new ResourceLocation("textures/entity/chicken.png"), (ModelBase)new ModelChicken());
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestCow.class, RenderVanillaCow::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestSheep.class, RenderVanillaSheep::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityHarvestChicken.class, RenderVanillaChicken::new);
        }
    }

    public static void init() {
        for (Crop crop : Crop.REGISTRY.getValues()) {
            if (crop == Crop.NULL_CROP || crop.getFoodType() == null) continue;
            HFApi.animals.registerFoodAsType(crop.getCropStack(1), crop.getFoodType());
        }
    }

    public static void configure() {
        CAN_SPAWN = ConfigHelper.getBoolean("Enable animal natural spawning", true);
        DISABLE_SPAWN_CHICKEN = ConfigHelper.getBoolean("Disable vanilla chickens from eggs", false);
        PICKUP_CHICKENS = ConfigHelper.getBoolean("Enable placing of chickens on your head", true);
        PREGNANCY_TIMER = ConfigHelper.getInteger("Pregnancy > Number of days", 7);
        CHICKEN_TIMER = PREGNANCY_TIMER / 2;
        MAX_LITTER_SIZE = ConfigHelper.getInteger("Pregnancy > Max litter size", 5);
        LITTER_EXTRA_CHANCE = ConfigHelper.getInteger("Pregnancy > Chance of extra birth", 4);
        AGING_TIMER = ConfigHelper.getInteger("Number of days animals take to mature", 14);
        OP_ANIMALS = ConfigHelper.getBoolean("Old Mcdonald had a farm", false);
        VANILLA_MODELS = ConfigHelper.getBoolean("Use vanilla models for animals", false);
    }
}

