/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import joshie.harvest.animals.AnimalData;
import joshie.harvest.animals.AnimalTracker;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AnimalTrackerServer
extends AnimalTracker {
    private static final DamageSource natural_causes = new DamageSource("natural").func_76348_h();
    private final HashSet<AnimalData> animals = new HashSet();
    private static final Set<Runnable> queue = new HashSet<Runnable>();

    public static void addToQueue(Runnable r) {
        queue.add(r);
    }

    public static void processQueue() {
        HashSet<Runnable> toProcess = new HashSet<Runnable>(queue);
        queue.clear();
        toProcess.forEach(Runnable::run);
    }

    @Override
    public void onDeath(IAnimalTracked animal) {
        animal.getData().setDead();
    }

    public void onJoinWorld(AnimalData animal) {
        this.animals.add(animal);
    }

    public void newDay() {
        World world = this.getWorld();
        Iterator<AnimalData> iterator = this.animals.iterator();
        while (iterator.hasNext()) {
            AnimalData data = iterator.next();
            EntityAnimal animal = data.getAnimal();
            if (!world.field_72996_f.contains(animal) || animal != null && !animal.field_70128_L && data.newDay()) continue;
            iterator.remove();
            if (animal == null || animal.field_70128_L) continue;
            animal.func_70097_a(natural_causes, 1000.0f);
            for (PlayerTracker playerTracker : HFTrackers.getPlayerTrackers()) {
                playerTracker.getRelationships().clear(EntityHelper.getEntityUUID((Entity)animal));
            }
        }
    }
}

