/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals;

import java.util.HashMap;
import java.util.Locale;
import joshie.harvest.animals.AnimalData;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalHandler;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.IAnimalType;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.holder.HolderRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@HFApiImplementation
public class AnimalRegistry
implements IAnimalHandler {
    public static final AnimalRegistry INSTANCE = new AnimalRegistry();
    private final HashMap<String, IAnimalType> types = new HashMap();
    private final HolderRegistry<AnimalFoodType> registry = new HolderRegistry();

    private AnimalRegistry() {
    }

    static void registerFoodsAsType(AnimalFoodType type, Item ... items) {
        for (Item item : items) {
            HFApi.animals.registerFoodAsType(new ItemStack(item, 1, Short.MAX_VALUE), type);
        }
    }

    @Override
    public void registerFoodAsType(ItemStack stack, AnimalFoodType type) {
        this.registry.register(stack, type);
    }

    @Override
    public boolean canAnimalEatFoodType(IAnimalTracked tracked, AnimalFoodType type) {
        for (AnimalFoodType t : tracked.getData().getType().getFoodTypes()) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canEat(ItemStack stack, AnimalFoodType ... types) {
        for (AnimalFoodType type : types) {
            if (!this.registry.matches((AnimalFoodType)stack, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAnimalData newData(IAnimalTracked animal, String type) {
        return new AnimalData(animal, this.types.get(type));
    }

    @Override
    public void registerType(String key, IAnimalType type) {
        this.types.put(key.toLowerCase(Locale.ENGLISH), type);
    }

    @Override
    public IAnimalType getTypeFromString(String string) {
        return this.types.get(string.toLowerCase(Locale.ENGLISH));
    }
}

