/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals;

import joshie.harvest.animals.AnimalData;
import joshie.harvest.animals.AnimalTracker;
import joshie.harvest.animals.AnimalTrackerServer;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.item.ItemAnimalTool;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HFEvents
public class AnimalEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityLoaded(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity instanceof IAnimalTracked) {
            AnimalTrackerServer.addToQueue(() -> ((AnimalTrackerServer)HFTrackers.getAnimalTracker(event.getWorld())).onJoinWorld((AnimalData)((IAnimalTracked)entity).getData()));
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof IAnimalTracked) {
            ((AnimalTracker)HFTrackers.getAnimalTracker(event.getEntityLiving().field_70170_p)).onDeath((IAnimalTracked)event.getEntityLiving());
        }
    }

    @HFEvents
    public static class PickupChicken {
        public static boolean register() {
            return HFAnimals.PICKUP_CHICKENS;
        }

        public boolean isChickenItem(EntityPlayer player) {
            return InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.CHICKEN_FEED), new int[0]) != null || InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM_STACK, HFAnimals.TOOLS.getStackFromEnum(ItemAnimalTool.Tool.MEDICINE), new int[0]) != null || InventoryHelper.getHandItemIsIn(player, InventoryHelper.ITEM, HFAnimals.TREATS, new int[0]) != null;
        }

        @SubscribeEvent
        public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity entity;
            EntityPlayer player = event.getEntityPlayer();
            if (!player.func_184207_aI() && !this.isChickenItem(player) && (entity = event.getTarget()) instanceof EntityChicken) {
                entity.func_184205_a((Entity)player, true);
            }
        }

        private boolean forbidsDrop(Block block) {
            return block instanceof BlockDoor || block instanceof BlockFenceGate || block instanceof BlockTrapDoor || block instanceof BlockLever || block instanceof BlockButton;
        }

        @SubscribeEvent
        public void onRightClickGround(PlayerInteractEvent.RightClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            if (!this.forbidsDrop(event.getWorld().func_180495_p(event.getPos()).func_177230_c())) {
                for (Entity entity : player.func_184188_bt()) {
                    if (!(entity instanceof EntityChicken)) continue;
                    entity.func_184210_p();
                    entity.field_70125_A = player.field_70125_A;
                    entity.field_70177_z = player.field_70177_z;
                    entity.func_70060_a(0.0f, 0.1f, 1.05f);
                    if (!(entity instanceof IAnimalTracked)) continue;
                    ((IAnimalTracked)entity).getData().dismount(player);
                }
            }
        }
    }
}

