/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals;

import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.item.ItemAnimalTreat;
import joshie.harvest.animals.packet.PacketSyncDaysNotFed;
import joshie.harvest.animals.packet.PacketSyncEverything;
import joshie.harvest.animals.packet.PacketSyncHealthiness;
import joshie.harvest.animals.packet.PacketSyncProductsProduced;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.IAnimalType;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.player.PlayerTrackerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AnimalData
implements IAnimalData {
    private static final Random rand = new Random();
    private final EntityAnimal animal;
    private final IAnimalType type;
    private WeakReference<EntityPlayer> owner;
    private UUID o_uuid;
    private int currentLifespan = 0;
    private int healthiness = 127;
    private int cleanliness = 0;
    private int stress = -128;
    private int daysNotFed;
    private boolean isSick;
    private boolean wasSick;
    private boolean hasDied;
    private int daysPassed;
    private int productsPerDay = 1;
    private int producedProducts;
    private boolean thrown;
    private boolean treated;
    private int genericTreats;
    private int typeTreats;
    private boolean isPregnant;
    private int daysPregnant;

    public AnimalData(IAnimalTracked animal, IAnimalType type) {
        this.animal = animal.getAsEntity();
        this.type = type;
    }

    @Override
    public IAnimalType getType() {
        return this.type;
    }

    private int getDeathChance() {
        EntityPlayer owner = this.getOwner();
        if (owner == null) {
            return Integer.MAX_VALUE;
        }
        if (this.daysNotFed > 0) {
            return Math.max(1, 45 - this.daysNotFed * 3);
        }
        int relationship = HFApi.relationships.getRelationship(owner, this.getUUID());
        double chance = (double)relationship / (double)HFNPCs.MAX_FRIENDSHIP * 200.0;
        if ((chance += (double)this.healthiness) <= 1.0) {
            chance = 1.0;
        }
        return (int)chance;
    }

    @Override
    public void setDead() {
        this.hasDied = true;
    }

    public boolean newDay() {
        if (this.animal != null) {
            if (this.hasDied) {
                return false;
            }
            if (this.currentLifespan > this.type.getMaxLifespan()) {
                return false;
            }
            if (this.currentLifespan > this.type.getMinLifespan() && rand.nextInt(this.getDeathChance()) == 0) {
                this.hasDied = true;
                return false;
            }
            if (!this.isSick && this.healthiness < 0) {
                this.isSick = true;
            }
            ++this.currentLifespan;
            int originalHealth = this.healthiness;
            this.healthiness -= this.daysNotFed;
            if (this.getType().getsDirty()) {
                --this.cleanliness;
            }
            World world = this.animal.field_70170_p;
            boolean isOutside = world.func_175710_j(new BlockPos((Entity)this.animal));
            boolean isRaining = world.func_72896_J();
            if (isRaining && isOutside || !isRaining && !isOutside) {
                this.stress = (byte)Math.min(127, this.stress + 50);
            } else if (this.stress > -128) {
                --this.stress;
            }
            if (this.stress > 0) {
                --this.healthiness;
            }
            if (this.getType().getsDirty()) {
                if (this.cleanliness < 0) {
                    this.healthiness += this.cleanliness;
                } else if (this.cleanliness >= 0) {
                    this.cleanliness = 0;
                }
            }
            if (this.healthiness == originalHealth) {
                this.healthiness += 10;
            }
            this.healthiness = Math.min(127, Math.max(-128, this.healthiness));
            ++this.daysNotFed;
            ++this.daysPassed;
            this.thrown = false;
            if (this.isPregnant) {
                ++this.daysPregnant;
            }
            if (this.isSick) {
                if (!this.wasSick) {
                    this.wasSick = true;
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1000000, 0));
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 1000000, 0));
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1000000, 0));
                }
            } else if (this.wasSick) {
                this.wasSick = false;
                this.animal.func_184589_d(MobEffects.field_76431_k);
                this.animal.func_184589_d(MobEffects.field_76440_q);
                this.animal.func_184589_d(MobEffects.field_76421_d);
            }
            if (this.treated && this.productsPerDay < 5) {
                int requiredGeneric = this.type.getGenericTreatCount();
                int requiredType = this.type.getTypeTreatCount();
                if (this.genericTreats >= requiredGeneric && this.typeTreats >= requiredType) {
                    this.genericTreats -= requiredGeneric;
                    this.typeTreats -= requiredType;
                    ++this.productsPerDay;
                }
            }
            this.treated = false;
            int daysBetween = this.type.getDaysBetweenProduction();
            if (daysBetween > 0 && this.daysPassed >= daysBetween) {
                this.daysPassed = 0;
                this.producedProducts = 0;
                this.type.refreshProduct(this, this.animal);
            }
            if (this.isPregnant) {
                ++this.daysPregnant;
                if (this.daysPregnant >= HFAnimals.PREGNANCY_TIMER) {
                    this.isPregnant = false;
                    this.daysPregnant = 0;
                    this.giveBirth();
                }
            }
            if (this.animal.func_70631_g_()) {
                this.animal.func_110195_a(1200);
            }
            PacketHandler.sendToEveryone(new PacketSyncEverything(this.animal.func_145782_y(), this));
            return true;
        }
        return false;
    }

    @Override
    public boolean isHungry() {
        return this.daysNotFed >= 0;
    }

    public UUID getUUID() {
        return EntityHelper.getEntityUUID((Entity)this.getAnimal());
    }

    public EntityAnimal getAnimal() {
        return this.animal;
    }

    @Override
    public int getProductsPerDay() {
        return this.productsPerDay;
    }

    private EntityPlayer getAndCreateOwner() {
        if (this.owner != null) {
            return (EntityPlayer)this.owner.get();
        }
        if (this.o_uuid != null) {
            this.owner = new WeakReference<EntityPlayerMP>(EntityHelper.getPlayerFromUUID(this.o_uuid));
            return (EntityPlayer)this.owner.get();
        }
        return null;
    }

    @Override
    public EntityPlayer getOwner() {
        EntityPlayer owner = this.getAndCreateOwner();
        if (owner != null && this.animal.field_70170_p.field_73011_w.getDimension() == owner.field_70170_p.field_73011_w.getDimension() && (double)this.animal.func_70032_d((Entity)owner) <= 178.0) {
            return owner;
        }
        return null;
    }

    @Override
    public void setOwner(@Nonnull UUID uuid) {
        this.o_uuid = uuid;
    }

    @Override
    public boolean canProduce() {
        return this.healthiness > 0 && this.producedProducts < this.productsPerDay;
    }

    @Override
    public void setProduced(int amount) {
        this.producedProducts += amount;
        PacketHandler.sendToEveryone(new PacketSyncProductsProduced(this.animal.func_145782_y(), this.producedProducts));
    }

    @Override
    public void clean(@Nullable EntityPlayer player) {
        if (this.cleanliness < 127) {
            this.cleanliness = (byte)Math.min(127, this.cleanliness + 10);
            if (this.cleanliness >= 127) {
                this.affectRelationship(player, 25);
            }
        }
    }

    @Override
    public void dismount(EntityPlayer player) {
        if (!this.thrown) {
            this.thrown = true;
            this.getAnimal().func_146082_f(player);
        }
    }

    private void affectRelationship(EntityPlayer player, int amount) {
        if (player != null) {
            ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getRelationships().affectRelationship(player, this.getUUID(), amount);
        }
    }

    @Override
    public void feed(@Nullable EntityPlayer player) {
        if (this.daysNotFed >= 0) {
            this.daysNotFed = -1;
            this.affectRelationship(player, 5);
            PacketHandler.sendToEveryone(new PacketSyncDaysNotFed(this.animal.func_145782_y(), (byte)this.daysNotFed));
        }
    }

    @Override
    public boolean heal(@Nullable EntityPlayer player) {
        if (this.healthiness < 27) {
            this.healthiness = 127;
            this.isSick = false;
            this.getAnimal().func_70674_bp();
            PacketHandler.sendToEveryone(new PacketSyncHealthiness(this.animal.func_145782_y(), (byte)this.healthiness));
            return true;
        }
        return false;
    }

    @Override
    public boolean treat(ItemStack stack, @Nullable EntityPlayer player) {
        if (!this.treated) {
            boolean bl = this.treated = HFAnimals.TREATS.getEnumFromStack(stack) == ItemAnimalTreat.Treat.GENERIC;
            if (this.treated) {
                ++this.genericTreats;
                this.affectRelationship(player, 1);
                this.treated = !HFAnimals.OP_ANIMALS;
                return true;
            }
            boolean bl2 = this.treated = HFApi.animals.getTypeFromString(((ItemAnimalTreat.Treat)((Object)HFAnimals.TREATS.getEnumFromStack(stack))).name()) == this.type;
            if (this.treated) {
                ++this.typeTreats;
                this.affectRelationship(player, 2);
                this.treated = !HFAnimals.OP_ANIMALS;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean impregnate(EntityPlayer player) {
        if (this.animal.func_70654_ax() < 0) {
            return false;
        }
        if (this.isPregnant) {
            return false;
        }
        this.daysPregnant = 0;
        this.isPregnant = true;
        this.affectRelationship(player, 200);
        return true;
    }

    private void giveBirth() {
        int i;
        int count = 1;
        for (i = 0; i < HFAnimals.MAX_LITTER_SIZE - 1; ++i) {
            if (!(rand.nextDouble() * 100.0 <= (double)HFAnimals.LITTER_EXTRA_CHANCE)) continue;
            ++count;
        }
        for (i = 0; i < count; ++i) {
            EntityAgeable baby = this.animal.func_90011_a((EntityAgeable)this.animal);
            baby.func_70873_a(-((int)(HFCalendar.TICKS_PER_DAY * (long)HFAnimals.AGING_TIMER)));
            baby.func_70012_b(this.animal.field_70165_t, this.animal.field_70163_u, this.animal.field_70161_v, 0.0f, 0.0f);
            ((IAnimalTracked)baby).getData().setOwner(this.o_uuid);
            int parent = ((PlayerTrackerServer)HFTrackers.getPlayerTracker(this.animal.field_70170_p, this.o_uuid)).getRelationships().getRelationship(this.getUUID());
            ((PlayerTracker)HFTrackers.getPlayerTracker(this.animal.field_70170_p, this.o_uuid)).getRelationships().copyRelationship(this.getOwner(), parent, ((IAnimalTracked)baby).getUUID(), 50.0);
            this.animal.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    public void setHealthiness(int healthiness) {
        this.healthiness = healthiness;
    }

    public void setDaysNotFed(int daysNotFed) {
        this.daysNotFed = daysNotFed;
    }

    public void setProductsProduced(int producedProducts) {
        this.producedProducts = producedProducts;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.healthiness);
        buf.writeByte(this.daysNotFed);
        buf.writeByte(this.productsPerDay);
        buf.writeByte(this.producedProducts);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.healthiness = buf.readByte();
        this.daysNotFed = buf.readByte();
        this.productsPerDay = buf.readByte();
        this.producedProducts = buf.readByte();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Owner")) {
            this.o_uuid = UUID.fromString(nbt.func_74779_i("Owner"));
        }
        this.currentLifespan = nbt.func_74765_d("CurrentLifespan");
        this.healthiness = nbt.func_74771_c("Healthiness");
        this.cleanliness = nbt.func_74771_c("Cleanliness");
        this.stress = nbt.func_74771_c("Stress");
        this.daysNotFed = nbt.func_74771_c("DaysNotFed");
        this.daysPassed = nbt.func_74771_c("DaysPassed");
        this.treated = nbt.func_74767_n("Treated");
        this.genericTreats = nbt.func_74765_d("GenericTreats");
        this.typeTreats = nbt.func_74765_d("TypeTreats");
        this.wasSick = nbt.func_74767_n("WasSick");
        this.isSick = nbt.func_74767_n("IsSick");
        this.thrown = nbt.func_74767_n("Thrown");
        if (this.type.getDaysBetweenProduction() > 0) {
            this.productsPerDay = nbt.func_74771_c("NumProducts");
            this.producedProducts = nbt.func_74771_c("ProducedProducts");
        }
        this.isPregnant = nbt.func_74767_n("IsPregnant");
        this.daysPregnant = nbt.func_74771_c("DaysPregnant");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.o_uuid != null) {
            nbt.func_74778_a("Owner", this.o_uuid.toString());
        }
        nbt.func_74777_a("CurrentLifespan", (short)this.currentLifespan);
        nbt.func_74774_a("Healthiness", (byte)this.healthiness);
        nbt.func_74774_a("Cleanliness", (byte)this.cleanliness);
        nbt.func_74774_a("Stress", (byte)this.stress);
        nbt.func_74774_a("DaysNotFed", (byte)this.daysNotFed);
        nbt.func_74774_a("DaysPassed", (byte)this.daysPassed);
        nbt.func_74757_a("Treated", this.treated);
        nbt.func_74777_a("GenericTreats", (short)this.genericTreats);
        nbt.func_74777_a("TypeTreats", (short)this.typeTreats);
        nbt.func_74757_a("WasSick", this.wasSick);
        nbt.func_74757_a("IsSick", this.isSick);
        nbt.func_74757_a("Thrown", this.thrown);
        if (this.type.getDaysBetweenProduction() > 0) {
            nbt.func_74774_a("NumProducts", (byte)this.productsPerDay);
            nbt.func_74774_a("ProducedProducts", (byte)this.producedProducts);
        }
        nbt.func_74757_a("IsPregnant", this.isPregnant);
        nbt.func_74774_a("DaysPregnant", (byte)this.daysPregnant);
    }
}

