/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.util.UniqueMetaIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UniqueMetaRegistry<E> {
    private Map<UniqueMetaIdentifier, E> registry = new HashMap<UniqueMetaIdentifier, E>();

    public void register(UniqueMetaIdentifier id, E entry) {
        this.registry.put(id, entry);
    }

    public E getEntry(UniqueMetaIdentifier id) {
        if (id == null) {
            return null;
        }
        if (this.registry.containsKey(id)) {
            return this.registry.get(id);
        }
        if (id.getMeta() != Short.MAX_VALUE) {
            if (this.registry.containsKey(id = new UniqueMetaIdentifier(id.getResourceLocation()))) {
                return this.registry.get(id);
            }
            if (!id.getName().isEmpty() && this.registry.containsKey(id = new UniqueMetaIdentifier(id.getModID(), ""))) {
                return this.registry.get(id);
            }
        }
        return null;
    }

    public void remove(UniqueMetaIdentifier id) {
        if (id != null) {
            this.registry.remove(id);
        }
    }

    public Set<Map.Entry<UniqueMetaIdentifier, E>> entrySet() {
        return this.registry.entrySet();
    }

    public void clear() {
        this.registry.clear();
    }
}

