/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class InventoryStorage
implements IInventory {
    public StorageRenderItem activeRenderItem;
    private TileEntityDrawers tile;
    private InventorySnapshot snapshot;

    public InventoryStorage(TileEntityDrawers tileEntity) {
        this.tile = tileEntity;
        this.snapshot = new InventorySnapshot(this.tile.func_70302_i_());
    }

    public int func_70302_i_() {
        return this.tile.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        int drawerSlot = this.tile.getDrawerInventory().getDrawerSlot(slot);
        IDrawer drawer = this.tile.getDrawerIfEnabled(drawerSlot);
        if (drawer == null) {
            return null;
        }
        ItemStack stack = drawer.getStoredItemCopy();
        if (stack == null) {
            return null;
        }
        stack.field_77994_a = drawer.getStoredItemCount();
        ItemStack snapStack = this.snapshot.takeSnapshot(stack, slot);
        if (this.activeRenderItem != null) {
            this.activeRenderItem.overrideStack = snapStack;
        }
        return snapStack;
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.snapshot.takeSnapshot(this.tile.func_70298_a(slot, count), slot);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
    }

    public String func_70005_c_() {
        return this.tile.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.tile.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.tile.func_145748_c_();
    }

    public int func_70297_j_() {
        int limit = this.tile.func_70297_j_();
        return limit > 64 ? 64 : limit;
    }

    public void func_70296_d() {
        int n = this.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            int diff = this.snapshot.splitDiff(i);
            if (diff == 0 || (stack = this.tile.func_70301_a(i)) == null) continue;
            stack.field_77994_a += diff;
        }
        this.tile.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.tile.func_94041_b(slot, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    private static class InventorySnapshot {
        private ItemStack[] snapshotItems;
        private int[] snapshotCounts;

        public InventorySnapshot(int size) {
            this.snapshotItems = new ItemStack[size];
            this.snapshotCounts = new int[this.snapshotItems.length];
        }

        public ItemStack takeSnapshot(ItemStack stack, int slot) {
            if (stack != null) {
                this.snapshotItems[slot] = stack;
                this.snapshotCounts[slot] = stack.field_77994_a;
            } else {
                this.snapshotItems[slot] = null;
                this.snapshotCounts[slot] = 0;
            }
            return stack;
        }

        public int getDiff(int slot) {
            if (this.snapshotItems[slot] == null) {
                return 0;
            }
            return this.snapshotItems[slot].field_77994_a - this.snapshotCounts[slot];
        }

        public int splitDiff(int slot) {
            int diff = this.getDiff(slot);
            if (diff != 0) {
                this.snapshotCounts[slot] = this.snapshotItems[slot].field_77994_a;
            }
            return diff;
        }
    }
}

