/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.chameleon.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.core.recipe.TemplateRecipe;
import com.jaquadro.minecraft.storagedrawers.integration.jei.TemplateRecipeHandler;
import com.jaquadro.minecraft.storagedrawers.integration.jei.TemplateRecipeWrapper;
import java.util.HashSet;
import java.util.Set;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JustEnoughItems
extends IntegrationModule
implements IModPlugin {
    private static final String MOD_ID = "JEI";
    private static Set<ItemStack> pendingHide = new HashSet<ItemStack>();
    private static IItemBlacklist blacklist;

    public String getModID() {
        return MOD_ID;
    }

    public void init() throws Throwable {
    }

    public void postInit() {
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(IModRegistry registry) {
        TemplateRecipeWrapper templateWrapper = new TemplateRecipeWrapper(new TemplateRecipe(), registry.getJeiHelpers());
        TemplateRecipeHandler templateHandler = new TemplateRecipeHandler(templateWrapper);
        registry.addRecipeHandlers(new IRecipeHandler[]{templateHandler});
        blacklist = registry.getJeiHelpers().getItemBlacklist();
        for (ItemStack stack : pendingHide) {
            blacklist.addItemToBlacklist(stack);
        }
        pendingHide.clear();
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    private static void hideItem(ItemStack stack) {
        blacklist.addItemToBlacklist(stack);
    }

    public static void hideBlock(String blockResource) {
        Block block = Block.func_149684_b((String)blockResource);
        if (block != null) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
            if (blacklist != null) {
                JustEnoughItems.hideItem(stack);
            } else {
                pendingHide.add(stack);
            }
        }
    }
}

