/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mods.betterfoliage.loader.Refs;
import mods.octarinecore.client.render.HSB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001c\u001a\u00020\u0011\u001a\u0012\u0010\u001d\u001a\u00020\u001b*\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0019\u001a\u001d\u0010\u001f\u001a\u00020\n*\u00020\u00062\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0086\u0002\u001a\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u000b*\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0086\u0002\u001a\u001f\u0010\u001f\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0086\u0002\u001a\u0017\u0010\u001f\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010(\u001a\u00020\u0011H\u0086\u0002\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190**\u00020$\u001a\u0012\u0010+\u001a\n ,*\u0004\u0018\u00010\u00060\u0006*\u00020$\u001a\u0015\u0010-\u001a\u00020\u0011*\u00020\u00112\u0006\u0010.\u001a\u00020\u0019H\u0086\u0002\u001a%\u0010/\u001a\u000200*\u00020\u00062\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0086\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\",\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f*\u00020\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"resourceManager", "Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "getResourceManager", "()Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "asStream", "Ljava/io/InputStream;", "Ljava/awt/image/BufferedImage;", "getAsStream", "(Ljava/awt/image/BufferedImage;)Ljava/io/InputStream;", "averageColor", "", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getAverageColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Ljava/lang/Integer;", "modelBlockAndLoc", "Lkotlin/Pair;", "Lnet/minecraft/client/renderer/block/model/ModelBlock;", "Lnet/minecraft/util/ResourceLocation;", "Lnet/minecraftforge/client/model/IModel;", "modelBlockAndLoc$annotations", "(Lnet/minecraftforge/client/model/IModel;)V", "getModelBlockAndLoc", "(Lnet/minecraftforge/client/model/IModel;)Lkotlin/Pair;", "textureLocation", "iconName", "", "derivesFrom", "", "targetLocation", "derivesFromModel", "modelLoc", "get", "x", "y", "Lnet/minecraft/client/renderer/texture/TextureMap;", "name", "Lnet/minecraft/client/resources/IResource;", "Lnet/minecraft/client/resources/IResourceManager;", "domain", "path", "location", "getLines", "", "loadImage", "kotlin.jvm.PlatformType", "plus", "str", "set", "", "value", "BetterFoliage-compileKotlin"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    public static final SimpleReloadableResourceManager getResourceManager() {
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
        if (iResourceManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.resources.SimpleReloadableResourceManager");
        }
        return (SimpleReloadableResourceManager)iResourceManager;
    }

    @NotNull
    public static final ResourceLocation plus(@NotNull ResourceLocation $receiver, @NotNull String str) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(str, "str");
        return new ResourceLocation($receiver.func_110624_b(), $receiver.func_110623_a() + str);
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $receiver, @NotNull String domain, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(domain, "domain");
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Utils.get($receiver, new ResourceLocation(domain, path));
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $receiver, @NotNull ResourceLocation location) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(location, "location");
        return mods.octarinecore.Utils.tryDefault(null, (Function0)new Function0<IResource>($receiver, location){
            final /* synthetic */ IResourceManager receiver$0;
            final /* synthetic */ ResourceLocation $location;

            public final IResource invoke() {
                return this.receiver$0.func_110536_a(this.$location);
            }
            {
                this.receiver$0 = iResourceManager;
                this.$location = resourceLocation;
                super(0);
            }
        });
    }

    @Nullable
    public static final TextureAtlasSprite get(@NotNull TextureMap $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(name, "name");
        return $receiver.getTextureExtry(new ResourceLocation(name).toString());
    }

    public static final BufferedImage loadImage(@NotNull IResource $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ImageIO.read($receiver.func_110527_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getLines(@NotNull IResource $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList<String> result = CollectionsKt.arrayListOf(new String[0]);
        InputStream inputStream = $receiver.func_110527_b();
        Object object = null;
        int n = 1;
        Closeable closeable = null;
        if (closeable != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (n & true) {
            object = Charsets.UTF_8;
        }
        closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n2 = 0;
        boolean bl = true;
        Sequence<String> sequence = null;
        if (sequence != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n2 = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Reader $receiver$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        object = $receiver$iv;
        n = 0;
        boolean bl2 = true;
        Object var6_11 = null;
        if (var6_11 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl2 & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        n = 0;
        try {
            void $receiver$iv2;
            Sequence<String> it;
            BufferedReader it$iv = (BufferedReader)object;
            sequence = it = TextStreamsKt.lineSequence(it$iv);
            for (Object element$iv : $receiver$iv2) {
                String it2 = (String)element$iv;
                result.add(it2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            n = 1;
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (n == 0) {
                object.close();
            }
        }
        return result;
    }

    public static final int get(@NotNull BufferedImage $receiver, int x, int y) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getRGB(x, y);
    }

    public static final void set(@NotNull BufferedImage $receiver, int x, int y, int value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.setRGB(x, y, value);
    }

    @NotNull
    public static final InputStream getAsStream(@NotNull BufferedImage $receiver) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        ByteArrayOutputStream it = byteArrayOutputStream;
        ImageIO.write((RenderedImage)$receiver, "PNG", it);
        byte[] byArray = it.toByteArray();
        byteArrayInputStream2(byArray);
        return byteArrayInputStream3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer getAverageColor(@NotNull TextureAtlasSprite $receiver) {
        ResourceLocation resourceLocation;
        String string;
        Object[] $receiver$iv$iv;
        ResourceLocation resourceLocation2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ResourceLocation resourceLocation3 = new ResourceLocation($receiver.func_94215_i());
        String str$iv = "blocks/";
        String string2 = $receiver$iv.func_110623_a();
        String string3 = $receiver$iv.func_110624_b();
        ResourceLocation resourceLocation4 = resourceLocation2;
        ResourceLocation resourceLocation5 = resourceLocation2;
        if (StringsKt.startsWith$default((String)$receiver$iv$iv, str$iv, false, 2, null)) {
            void var8_10 = $receiver$iv$iv;
            int n = str$iv.length();
            void v1 = var8_10;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)v1).substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = $receiver$iv$iv;
        }
        void var10_13 = string;
        resourceLocation4(string3, (String)var10_13);
        ResourceLocation locationNoDirs = resourceLocation5;
        str$iv = "textures/blocks/%s.png";
        $receiver$iv$iv = new Object[]{locationNoDirs.func_110623_a()};
        String string5 = locationNoDirs.func_110624_b();
        ResourceLocation resourceLocation6 = resourceLocation;
        ResourceLocation resourceLocation7 = resourceLocation;
        String string6 = String.format(str$iv, Arrays.copyOf($receiver$iv$iv, $receiver$iv$iv.length));
        Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(this, *args)");
        String string7 = string6;
        resourceLocation6(string5, string7);
        ResourceLocation locationWithDirs = resourceLocation7;
        Object object = Utils.get((IResourceManager)Utils.getResourceManager(), locationWithDirs);
        if (object == null || (object = Utils.loadImage((IResource)object)) == null) {
            return null;
        }
        Object image = object;
        int numOpaque = 0;
        double sumHueX = 0.0;
        double sumHueY = 0.0;
        float sumSaturation = 0.0f;
        float sumBrightness = 0.0f;
        int $i$f$stripStart = 0;
        int n = ((BufferedImage)image).getWidth() - 1;
        if ($i$f$stripStart <= n) {
            while (true) {
                void x;
                int n2;
                int n3;
                if ((n3 = 0) <= (n2 = ((BufferedImage)image).getHeight() - 1)) {
                    while (true) {
                        void y;
                        int pixel = Utils.get((BufferedImage)image, (int)x, (int)y);
                        int alpha = pixel >> 24 & 0xFF;
                        HSB hsb = HSB.Companion.fromColor(pixel);
                        if (alpha == 255) {
                            ++numOpaque;
                            sumHueX += Math.cos(((double)hsb.getHue() - 0.5) * mods.octarinecore.Utils.PI2);
                            sumHueY += Math.sin(((double)hsb.getHue() - 0.5) * mods.octarinecore.Utils.PI2);
                            sumSaturation += hsb.getSaturation();
                            sumBrightness += hsb.getBrightness();
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / mods.octarinecore.Utils.PI2 + 0.5);
        return new HSB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque).getAsColor();
    }

    @NotNull
    public static final ResourceLocation textureLocation(@NotNull String iconName) {
        Intrinsics.checkParameterIsNotNull(iconName, "iconName");
        ResourceLocation resourceLocation = new ResourceLocation(iconName);
        ResourceLocation it = resourceLocation;
        return StringsKt.startsWith$default(it.func_110623_a(), "mcpatcher", false, 2, null) ? it : new ResourceLocation(it.func_110624_b(), "textures/" + it.func_110623_a());
    }

    private static final /* synthetic */ void modelBlockAndLoc$annotations(IModel iModel) {
    }

    @Nullable
    public static final Pair<ModelBlock, ResourceLocation> getModelBlockAndLoc(@NotNull IModel $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (Refs.INSTANCE.getVanillaModelWrapper().isInstance($receiver)) {
            Object object = Refs.INSTANCE.getModel_VMW().get($receiver);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.renderer.block.model.ModelBlock");
            }
            Object object2 = Refs.INSTANCE.getLocation_VMW().get($receiver);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.util.ResourceLocation");
            }
            return new Pair<ModelBlock, ResourceLocation>((ModelBlock)object, (ResourceLocation)object2);
        }
        if (Refs.INSTANCE.getWeightedRandomModel().isInstance($receiver)) {
            Object object = Refs.INSTANCE.getModels_WRM().get($receiver);
            if (object != null) {
                Object it;
                Object object3 = object;
                Object object4 = it = object3;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<net.minecraftforge.client.model.IModel>");
                }
                Iterable $receiver$iv = (List)object4;
                for (Object element$iv : $receiver$iv) {
                    IModel it2 = (IModel)element$iv;
                    Pair<ModelBlock, ResourceLocation> pair = Utils.getModelBlockAndLoc(it2);
                    Pair<ModelBlock, ResourceLocation> it3 = pair;
                    if (it3 == null) continue;
                    return it3;
                }
            }
        } else if (Refs.INSTANCE.getMultiModel().isInstance($receiver)) {
            Object object = Refs.INSTANCE.getBase_MM().get($receiver);
            if (object != null) {
                Object it;
                Object object5 = object;
                Object object6 = it = object5;
                if (object6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.client.model.IModel");
                }
                return Utils.getModelBlockAndLoc((IModel)object6);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean derivesFrom(@NotNull Pair<? extends ModelBlock, ? extends ResourceLocation> $receiver, @NotNull ResourceLocation targetLocation) {
        String string;
        void $receiver$iv$iv;
        ResourceLocation resourceLocation;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(targetLocation, "targetLocation");
        ResourceLocation resourceLocation2 = $receiver.getSecond();
        String str$iv = "models/";
        String string2 = $receiver$iv.func_110623_a();
        String string3 = $receiver$iv.func_110624_b();
        ResourceLocation resourceLocation3 = resourceLocation;
        ResourceLocation resourceLocation4 = resourceLocation;
        if (StringsKt.startsWith$default((String)$receiver$iv$iv, str$iv, false, 2, null)) {
            void var8_8 = $receiver$iv$iv;
            int n = str$iv.length();
            void v1 = var8_8;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)v1).substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = $receiver$iv$iv;
        }
        void var10_10 = string;
        resourceLocation3(string3, (String)var10_10);
        if (Intrinsics.areEqual(resourceLocation4, targetLocation)) {
            return true;
        }
        if ($receiver.getFirst().field_178315_d != null && $receiver.getFirst().func_178305_e() != null) {
            ModelBlock modelBlock = $receiver.getFirst().field_178315_d;
            ResourceLocation resourceLocation5 = $receiver.getFirst().func_178305_e();
            if (resourceLocation5 == null) {
                Intrinsics.throwNpe();
            }
            return Utils.derivesFrom(new Pair<ModelBlock, ResourceLocation>(modelBlock, resourceLocation5), targetLocation);
        }
        return false;
    }

    public static final boolean derivesFromModel(@NotNull IModel $receiver, @NotNull String modelLoc) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(modelLoc, "modelLoc");
        Pair<ModelBlock, ResourceLocation> pair = Utils.getModelBlockAndLoc($receiver);
        return pair != null ? Utils.derivesFrom(pair, new ResourceLocation(modelLoc)) : false;
    }
}

