/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.BetterFoliageMod;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.betterfoliage.client.texture.GrassRegistryKt;
import mods.betterfoliage.client.texture.IGrassRegistry;
import mods.betterfoliage.client.texture.StandardLeafSupport;
import mods.octarinecore.client.render.HSB;
import mods.octarinecore.client.resource.LoadModelDataEvent;
import mods.octarinecore.client.resource.TextureListModelProcessor;
import mods.octarinecore.client.resource.TextureMediatedRegistry;
import mods.octarinecore.client.resource.Utils;
import mods.octarinecore.common.config.ConfigurableBlockMatcher;
import mods.octarinecore.common.config.ModelTextureList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u00020\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\bJ\u0012\u0010&\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u001aH\u0016J*\u0010&\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J(\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u00100\u001a\u000201H\u0016J&\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00042\u0006\u00105\u001a\u00020\u00022\u0006\u00100\u001a\u000201H\u0016J\u0016\u00106\u001a\u0002032\u0006\u00105\u001a\u00020\u00022\u0006\u00100\u001a\u000201R\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R,\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001eR&\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001e\u00a8\u00067"}, d2={"Lmods/betterfoliage/client/texture/StandardGrassSupport;", "Lmods/octarinecore/client/resource/TextureListModelProcessor;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "Lmods/octarinecore/client/resource/TextureMediatedRegistry;", "", "", "Lmods/betterfoliage/client/texture/GrassInfo;", "Lmods/betterfoliage/client/texture/IGrassRegistry;", "()V", "logName", "getLogName", "()Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "matchClasses", "Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "getMatchClasses", "()Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "modelTextures", "Lmods/octarinecore/common/config/ModelTextureList;", "getModelTextures", "()Ljava/util/List;", "stateToKey", "", "Lnet/minecraft/block/state/IBlockState;", "getStateToKey", "()Ljava/util/Map;", "setStateToKey", "(Ljava/util/Map;)V", "stateToValue", "", "getStateToValue", "setStateToValue", "textureToValue", "getTextureToValue", "setTextureToValue", "get", "state", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "face", "Lnet/minecraft/util/EnumFacing;", "processStitch", "key", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "processTexture", "", "states", "texture", "registerGrass", "BetterFoliage-compileKotlin"})
public final class StandardGrassSupport
implements TextureListModelProcessor<TextureAtlasSprite>,
TextureMediatedRegistry<List<? extends String>, GrassInfo>,
IGrassRegistry {
    @NotNull
    private static Map<IBlockState, List<String>> stateToKey;
    @NotNull
    private static Map<IBlockState, ? extends TextureAtlasSprite> stateToValue;
    @NotNull
    private static Map<TextureAtlasSprite, GrassInfo> textureToValue;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String logName = "StandardGrassSupport";
    public static final StandardGrassSupport INSTANCE;

    @Override
    @NotNull
    public Map<IBlockState, List<String>> getStateToKey() {
        return stateToKey;
    }

    @Override
    public void setStateToKey(@NotNull Map<IBlockState, List<String>> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
        stateToKey = map2;
    }

    @Override
    @NotNull
    public Map<IBlockState, TextureAtlasSprite> getStateToValue() {
        return stateToValue;
    }

    @Override
    public void setStateToValue(@NotNull Map<IBlockState, ? extends TextureAtlasSprite> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
        stateToValue = map2;
    }

    @Override
    @NotNull
    public Map<TextureAtlasSprite, GrassInfo> getTextureToValue() {
        return textureToValue;
    }

    @Override
    public void setTextureToValue(@NotNull Map<TextureAtlasSprite, GrassInfo> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
        textureToValue = map2;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public String getLogName() {
        return logName;
    }

    @Override
    @NotNull
    public ConfigurableBlockMatcher getMatchClasses() {
        return Config.blocks.INSTANCE.getGrassClasses();
    }

    @Override
    @NotNull
    public List<ModelTextureList> getModelTextures() {
        return Config.blocks.INSTANCE.getGrassModels().getList();
    }

    @Override
    @Nullable
    public GrassInfo get(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(face, "face");
        TextureAtlasSprite textureAtlasSprite = this.getStateToValue().get(state);
        if (textureAtlasSprite == null) {
            return null;
        }
        TextureAtlasSprite baseTexture = textureAtlasSprite;
        GrassInfo grassInfo = this.getTextureToValue().get(OptifineCTM.INSTANCE.override(baseTexture, world, pos, face));
        if (grassInfo == null) {
            grassInfo = this.getTextureToValue().get(baseTexture);
        }
        return grassInfo;
    }

    @Override
    @Nullable
    public GrassInfo get(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        TextureAtlasSprite textureAtlasSprite = StandardLeafSupport.INSTANCE.getStateToValue().get(state);
        TextureAtlasSprite it = textureAtlasSprite;
        return it == null ? (GrassInfo)null : INSTANCE.getTextureToValue().get(it);
    }

    @Override
    @Nullable
    public TextureAtlasSprite processStitch(@NotNull IBlockState state, @NotNull List<String> key, @NotNull TextureMap atlas) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        return Utils.get(atlas, key.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processTexture(@NotNull List<? extends IBlockState> states, @NotNull TextureAtlasSprite texture, @NotNull TextureMap atlas) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(states, "states");
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        this.registerGrass(texture, atlas);
        Iterable iterable = OptifineCTM.INSTANCE.getAllCTM(states, texture);
        for (Object element$iv : $receiver$iv) {
            TextureAtlasSprite it = (TextureAtlasSprite)element$iv;
            INSTANCE.registerGrass(it, atlas);
        }
    }

    public final void registerGrass(@NotNull TextureAtlasSprite texture, @NotNull TextureMap atlas) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        this.getLogger().log(Level.DEBUG, this.getLogName() + ": texture " + texture.func_94215_i());
        Integer n2 = Utils.getAverageColor(texture);
        HSB hsb = HSB.Companion.fromColor(n2 != null ? n2 : GrassRegistryKt.defaultGrassColor);
        if ((double)hsb.getSaturation() >= Config.shortGrass.INSTANCE.getSaturationThreshold()) {
            this.getLogger().log(Level.DEBUG, this.getLogName() + ":         saturation " + hsb.getSaturation() + " >= " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using texture color");
            n = HSB.copy$default(hsb, 0.0f, 0.0f, 0.9f, 3, null).getAsColor();
        } else {
            this.getLogger().log(Level.DEBUG, this.getLogName() + ":         saturation " + hsb.getSaturation() + " < " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using block color");
            n = null;
        }
        Integer overrideColor = n;
        Map<TextureAtlasSprite, GrassInfo> map2 = this.getTextureToValue();
        GrassInfo grassInfo = new GrassInfo(texture, overrideColor);
        map2.put(texture, grassInfo);
    }

    private StandardGrassSupport() {
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        stateToKey = MapsKt.mutableMapOf(new Pair[0]);
        stateToValue = MapsKt.emptyMap();
        textureToValue = MapsKt.mutableMapOf(new Pair[0]);
        logger = BetterFoliageMod.INSTANCE.getLogDetail();
        logName = logName;
    }

    static {
        new StandardGrassSupport();
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOW)
    public void handlePreStitch(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        TextureMediatedRegistry.DefaultImpls.handlePreStitch(this, event);
    }

    @Override
    @Nullable
    public List<String> processModelLoad(@NotNull IBlockState state, @NotNull ModelResourceLocation modelLoc, @NotNull IModel model) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(modelLoc, "modelLoc");
        Intrinsics.checkParameterIsNotNull(model, "model");
        return TextureListModelProcessor.DefaultImpls.processModelLoad(this, state, modelLoc, model);
    }

    @Override
    public void onPostLoad() {
        TextureListModelProcessor.DefaultImpls.onPostLoad(this);
    }

    @Override
    public void onPreStitch() {
        TextureListModelProcessor.DefaultImpls.onPreStitch(this);
    }

    @Override
    @SubscribeEvent
    public void handleLoadModelData(@NotNull LoadModelDataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, "event");
        TextureListModelProcessor.DefaultImpls.handleLoadModelData(this, event);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void clearBeforeLoadModelData(@NotNull LoadModelDataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, "event");
        TextureListModelProcessor.DefaultImpls.clearBeforeLoadModelData(this, event);
    }
}

