/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.BetterFoliageMod;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.texture.ILeafRegistry;
import mods.betterfoliage.client.texture.LeafInfo;
import mods.betterfoliage.client.texture.StandardLeafSupport;
import mods.betterfoliage.client.texture.TextureMatcher;
import mods.octarinecore.client.render.BlockContext;
import mods.octarinecore.client.resource.IconSet;
import mods.octarinecore.common.Int3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J+\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lmods/betterfoliage/client/texture/LeafRegistry;", "Lmods/betterfoliage/client/texture/ILeafRegistry;", "()V", "particles", "Ljava/util/HashMap;", "", "Lmods/octarinecore/client/resource/IconSet;", "getParticles", "()Ljava/util/HashMap;", "subRegistries", "", "getSubRegistries", "()Ljava/util/List;", "typeMappings", "Lmods/betterfoliage/client/texture/TextureMatcher;", "getTypeMappings", "()Lmods/betterfoliage/client/texture/TextureMatcher;", "get", "Lmods/betterfoliage/client/texture/LeafInfo;", "ctx", "Lmods/octarinecore/client/render/BlockContext;", "face", "Lnet/minecraft/util/EnumFacing;", "state", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getParticleType", "texture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "handlePreStitch", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "BetterFoliage-compileKotlin"})
public final class LeafRegistry
implements ILeafRegistry {
    @NotNull
    private static final List<ILeafRegistry> subRegistries;
    @NotNull
    private static final TextureMatcher typeMappings;
    @NotNull
    private static final HashMap<String, IconSet> particles;
    public static final LeafRegistry INSTANCE;

    @NotNull
    public final List<ILeafRegistry> getSubRegistries() {
        return subRegistries;
    }

    @NotNull
    public final TextureMatcher getTypeMappings() {
        return typeMappings;
    }

    @NotNull
    public final HashMap<String, IconSet> getParticles() {
        return particles;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void handlePreStitch(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        particles.clear();
        typeMappings.loadMappings(new ResourceLocation(BetterFoliageMod.DOMAIN, "leafTextureMappings.cfg"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public LeafInfo get(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        LeafInfo leafInfo;
        block1: {
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(state, "state");
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(face, "face");
            Iterable iterable = subRegistries;
            void var6_6 = $receiver$iv;
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LeafInfo it$iv;
                Object element$iv$iv;
                Object it$iv2 = element$iv$iv = iterator2.next();
                ILeafRegistry it = (ILeafRegistry)it$iv2;
                LeafInfo leafInfo2 = it.get(state, world, pos, face);
                if (leafInfo2 == null) continue;
                LeafInfo leafInfo3 = leafInfo2;
                leafInfo = it$iv = leafInfo3;
                break block1;
            }
            leafInfo = null;
        }
        return leafInfo;
    }

    @Nullable
    public final LeafInfo get(@NotNull BlockContext ctx, @NotNull EnumFacing face) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        Intrinsics.checkParameterIsNotNull(face, "face");
        IBlockState iBlockState = ctx.blockState(Int3.Companion.getZero());
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "ctx.blockState(Int3.zero)");
        IBlockAccess iBlockAccess = ctx.getWorld();
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = ctx.getPos();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "ctx.pos");
        return this.get(iBlockState, iBlockAccess, blockPos, face);
    }

    @Override
    @Nullable
    public LeafInfo get(@NotNull IBlockState state) {
        LeafInfo leafInfo;
        block1: {
            Intrinsics.checkParameterIsNotNull(state, "state");
            Iterable $receiver$iv = subRegistries;
            Iterable $receiver$iv$iv = $receiver$iv;
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LeafInfo it$iv;
                Object element$iv$iv;
                Object it$iv2 = element$iv$iv = iterator2.next();
                ILeafRegistry it = (ILeafRegistry)it$iv2;
                LeafInfo leafInfo2 = it.get(state);
                if (leafInfo2 == null) continue;
                LeafInfo leafInfo3 = leafInfo2;
                leafInfo = it$iv = leafInfo3;
                break block1;
            }
            leafInfo = null;
        }
        return leafInfo;
    }

    @NotNull
    public final String getParticleType(@NotNull TextureAtlasSprite texture, @NotNull TextureMap atlas) {
        String leafType;
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        String string = typeMappings.getType(texture);
        if (string == null) {
            string = leafType = "default";
        }
        if (particles.keySet().contains(leafType) ^ true) {
            IconSet particleSet = new IconSet("betterfoliage", "blocks/falling_leaf_" + leafType + "_%d");
            particleSet.onStitch(atlas);
            if (particleSet.getNum() == 0) {
                Client.INSTANCE.log(Level.WARN, "Leaf particle textures not found for leaf type: " + leafType);
                leafType = "default";
            } else {
                particles.put(leafType, particleSet);
            }
        }
        return leafType;
    }

    private LeafRegistry() {
        INSTANCE = this;
        subRegistries = CollectionsKt.mutableListOf(StandardLeafSupport.INSTANCE);
        typeMappings = new TextureMatcher();
        particles = MapsKt.hashMapOf(new Pair[0]);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        new LeafRegistry();
    }
}

