/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui.wizard.spi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeSelectionModel;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardPage;

final class GenericListener
implements ActionListener,
PropertyChangeListener,
ItemListener,
ContainerListener,
DocumentListener,
ChangeListener,
ListSelectionListener,
TreeSelectionListener,
TableModelListener {
    private final WizardPage wizardPage;
    private boolean ignoreEvents;
    private final Set listenedTo = new HashSet();
    private final WizardPage.CustomComponentListener extListener;
    private final WizardPage.CustomComponentNotifier extNotifier;

    public GenericListener(WizardPage wizardPage, WizardPage.CustomComponentListener l, WizardPage.CustomComponentNotifier n) {
        this.extListener = l;
        this.extNotifier = n;
        if (this.extListener == null != (this.extNotifier == null)) {
            throw new RuntimeException();
        }
        if (wizardPage == null) {
            throw new IllegalArgumentException("WizardPage may not be null");
        }
        this.wizardPage = wizardPage;
        wizardPage.addContainerListener(this);
    }

    public GenericListener(WizardPage page) {
        this(page, null, null);
    }

    protected boolean isProbablyAContainer(Component c) {
        boolean result;
        boolean bl = result = this.extListener != null ? this.extListener.isContainer(c) : false;
        if (!result) {
            boolean isSwing = this.isSwingClass(c);
            result = isSwing ? c instanceof JPanel || c instanceof JSplitPane || c instanceof JToolBar || c instanceof JViewport || c instanceof JScrollPane || c instanceof JFrame || c instanceof JRootPane || c instanceof Window || c instanceof Frame || c instanceof Dialog || c instanceof JTabbedPane || c instanceof JInternalFrame || c instanceof JDesktopPane || c instanceof JLayeredPane || c instanceof Box : c instanceof Container;
        }
        return result;
    }

    protected boolean isSwingClass(Component c) {
        String packageName = c.getClass().getPackage().getName();
        boolean swing = packageName.equals("javax.swing");
        return swing;
    }

    protected void attachTo(Component jc) {
        if (this.extListener != null && this.extListener.accept(jc)) {
            this.extListener.startListeningTo(jc, this.extNotifier);
            this.listenedTo.add(jc);
            if (this.wizardPage.getMapKeyFor(jc) != null) {
                this.wizardPage.maybeUpdateMap(jc);
            }
            return;
        }
        if (this.isProbablyAContainer(jc)) {
            this.attachToHierarchyOf((Container)jc);
        } else if (jc instanceof JList) {
            this.listenedTo.add(jc);
            ((JList)jc).addListSelectionListener(this);
        } else if (jc instanceof JComboBox) {
            ((JComboBox)jc).addActionListener(this);
        } else if (jc instanceof JTree) {
            this.listenedTo.add(jc);
            ((JTree)jc).getSelectionModel().addTreeSelectionListener(this);
        } else if (jc instanceof JToggleButton) {
            ((AbstractButton)jc).addItemListener(this);
        } else if (jc instanceof JFormattedTextField) {
            jc.addPropertyChangeListener("value", this);
        } else if (jc instanceof JTextComponent) {
            this.listenedTo.add(jc);
            ((JTextComponent)jc).getDocument().addDocumentListener(this);
        } else if (jc instanceof JColorChooser) {
            this.listenedTo.add(jc);
            ((JColorChooser)jc).getSelectionModel().addChangeListener(this);
        } else if (jc instanceof JSpinner) {
            ((JSpinner)jc).addChangeListener(this);
        } else if (jc instanceof JSlider) {
            ((JSlider)jc).addChangeListener(this);
        } else if (jc instanceof JTable) {
            this.listenedTo.add(jc);
            ((JTable)jc).getSelectionModel().addListSelectionListener(this);
        }
        if (this.accept(jc) && !(jc instanceof JPanel)) {
            jc.addPropertyChangeListener("name", this);
            if (this.wizardPage.getMapKeyFor(jc) != null) {
                this.wizardPage.maybeUpdateMap(jc);
            }
        }
    }

    protected void detachFrom(Component jc) {
        this.listenedTo.remove(jc);
        if (this.extListener != null && this.extListener.accept(jc)) {
            this.extListener.stopListeningTo(jc);
        }
        if (this.isProbablyAContainer(jc)) {
            this.detachFromHierarchyOf((Container)jc);
        } else if (jc instanceof JList) {
            ((JList)jc).removeListSelectionListener(this);
        } else if (jc instanceof JComboBox) {
            ((JComboBox)jc).removeActionListener(this);
        } else if (jc instanceof JTree) {
            ((JTree)jc).getSelectionModel().removeTreeSelectionListener(this);
        } else if (jc instanceof JToggleButton) {
            ((AbstractButton)jc).removeActionListener(this);
        } else if (!(jc instanceof JTextComponent)) {
            if (jc instanceof JFormattedTextField) {
                jc.removePropertyChangeListener("value", this);
                ((JTextComponent)jc).getDocument().removeDocumentListener(this);
            } else if (jc instanceof JColorChooser) {
                ((JColorChooser)jc).getSelectionModel().removeChangeListener(this);
            } else if (jc instanceof JSpinner) {
                ((JSpinner)jc).removeChangeListener(this);
            } else if (jc instanceof JSlider) {
                ((JSlider)jc).removeChangeListener(this);
            } else if (jc instanceof JTable) {
                ((JTable)jc).getSelectionModel().removeListSelectionListener(this);
            }
        }
        if (this.accept(jc) && !(jc instanceof JPanel)) {
            jc.removePropertyChangeListener("name", this);
            Object key = this.wizardPage.getMapKeyFor(jc);
            if (key != null) {
                this.wizardPage.removeFromMap(key);
            }
        }
    }

    private void detachFromHierarchyOf(Container container) {
        Component[] components;
        container.removeContainerListener(this);
        for (Component component : components = container.getComponents()) {
            this.detachFrom(component);
        }
    }

    void attachToHierarchyOf(Container container) {
        Component[] components;
        if (!Arrays.asList(container.getContainerListeners()).contains(this)) {
            container.addContainerListener(this);
        }
        for (Component component : components = container.getComponents()) {
            this.attachTo(component);
        }
    }

    protected boolean accept(Component jc) {
        if (this.extListener != null && this.extListener.accept(jc)) {
            return true;
        }
        if (!(jc instanceof JComponent)) {
            return false;
        }
        if (jc instanceof TableCellEditor || jc instanceof TreeCellEditor || SwingUtilities.getAncestorOfClass(JTable.class, jc) != null || SwingUtilities.getAncestorOfClass(JTree.class, jc) != null || SwingUtilities.getAncestorOfClass(JList.class, jc) != null) {
            return false;
        }
        return this.isProbablyAContainer(jc) || jc instanceof JList || jc instanceof JComboBox || jc instanceof JTree || jc instanceof JToggleButton || jc instanceof JTextComponent || jc instanceof JColorChooser || jc instanceof JSpinner || jc instanceof JSlider;
    }

    void setIgnoreEvents(boolean val) {
        this.ignoreEvents = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Object e) {
        block13: {
            if (!this.ignoreEvents) {
                this.setIgnoreEvents(true);
                try {
                    if (e instanceof EventObject && ((EventObject)e).getSource() instanceof Component) {
                        this.wizardPage.userInputReceived((Component)((EventObject)e).getSource(), e);
                        break block13;
                    }
                    if (e instanceof TreeSelectionEvent) {
                        TreeSelectionModel mdl = (TreeSelectionModel)((TreeSelectionEvent)e).getSource();
                        for (Object o : this.listenedTo) {
                            if (!(o instanceof JTree) || ((JTree)o).getSelectionModel() != mdl) continue;
                            this.wizardPage.userInputReceived((Component)o, e);
                            break block13;
                        }
                        break block13;
                    }
                    if (e instanceof DocumentEvent) {
                        Document document = ((DocumentEvent)e).getDocument();
                        for (Object o : this.listenedTo) {
                            if (!(o instanceof JTextComponent) || ((JTextComponent)o).getDocument() != document) continue;
                            this.wizardPage.userInputReceived((Component)o, e);
                            break block13;
                        }
                        break block13;
                    }
                    if (e instanceof ListSelectionEvent) {
                        ListSelectionModel model = (ListSelectionModel)((ListSelectionEvent)e).getSource();
                        for (Object o : this.listenedTo) {
                            if (o instanceof JList && ((JList)o).getSelectionModel() == model) {
                                this.wizardPage.userInputReceived((Component)o, e);
                            } else {
                                if (!(o instanceof JTable) || ((JTable)o).getSelectionModel() != model) continue;
                                this.wizardPage.userInputReceived((Component)o, e);
                            }
                            break block13;
                        }
                        break block13;
                    }
                    this.wizardPage.userInputReceived(null, e);
                }
                finally {
                    this.setIgnoreEvents(false);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fire(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof JComponent && "name".equals(e.getPropertyName())) {
            if (e.getOldValue() instanceof String) {
                this.wizardPage.removeFromMap(e.getOldValue());
            }
        } else if (e.getSource() instanceof JFormattedTextField && "value".equals(e.getPropertyName())) {
            this.fire(e);
            this.wizardPage.maybeUpdateMap((JComponent)e.getSource());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fire(e);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (this.accept(e.getChild())) {
            this.attachTo(e.getChild());
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (this.extListener != null && this.extListener.accept(e.getChild())) {
            this.extListener.stopListeningTo(e.getChild());
            this.listenedTo.remove(e.getChild());
        } else if (this.accept(e.getChild())) {
            this.detachFrom(e.getChild());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fire(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fire(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fire(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fire(e);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fire(e);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.fire(e);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fire(e);
    }
}

