/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui.wizard.modules;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.InstructionsPanel;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Wizard;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardObserver;

public class InstructionsPanelImpl
extends JComponent
implements WizardObserver,
Accessible,
InstructionsPanel {
    private final BufferedImage img;
    private final Wizard wizard;
    private static final int MARGIN = 5;
    String[] steps = new String[0];
    private int historicWidth = Integer.MIN_VALUE;
    String elipsis = "...";
    private boolean inSummaryPage;

    public InstructionsPanelImpl(Wizard wiz) {
        this(null, wiz);
        Font f = UIManager.getFont("Tree.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    protected final Wizard getWizard() {
        return this.wizard;
    }

    @Override
    public final Container getComponent() {
        return this;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.wizard.addWizardObserver(this);
    }

    @Override
    public void removeNotify() {
        this.wizard.removeWizardObserver(this);
        super.removeNotify();
    }

    protected BufferedImage getImage() {
        return this.img;
    }

    public InstructionsPanelImpl(BufferedImage img, Wizard wizard) {
        if (img == null) {
            try {
                img = ImageIO.read(InstructionsPanelImpl.class.getResourceAsStream("/org/jackhuang/hellominecraft/wizard.jpg"));
            }
            catch (IOException ioe) {
                HMCLog.err("Failed to load wizard.jpg, maybe you fucking modified the launcher", ioe);
            }
        }
        this.img = img;
        this.wizard = wizard;
    }

    @Override
    public boolean isOpaque() {
        return this.img != null;
    }

    protected void paintImage(Graphics2D g, int x, int y, int w, int h) {
        BufferedImage image = this.getImage();
        if (image != null) {
            g.drawImage(image, x, y, w, h, this);
        } else {
            Color c = g.getColor();
            g.setColor(Color.WHITE);
            g.fillRect(x, y, w, h);
            g.setColor(c);
        }
    }

    @Override
    public final void paintComponent(Graphics g) {
        boolean wontFit;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        int dx = ins.left;
        int dy = ins.top;
        int w = this.getWidth() - (ins.left + ins.right);
        int hh = this.getHeight() - (ins.top + ins.bottom);
        this.paintImage(g2d, dx, dy, w, hh);
        String currentStep = this.wizard.getCurrentStep();
        if (!this.inSummaryPage) {
            this.steps = this.wizard.getAllSteps();
        }
        String[] steps2 = this.steps;
        if (this.inSummaryPage) {
            String summaryStep = C.i18n("wizard.summary", new Object[0]);
            String[] nue = new String[steps2.length + 1];
            System.arraycopy(steps2, 0, nue, 0, steps2.length);
            nue[nue.length - 1] = summaryStep;
            steps2 = nue;
        }
        int y = fm.getMaxAscent() + ins.top + 5;
        int x = ins.left + 5;
        int h = fm.getMaxAscent() + fm.getMaxDescent() + 3;
        Font boldFont = f.deriveFont(1);
        g.setFont(boldFont);
        g.drawString(C.i18n("wizard.steps", new Object[0]), x, y);
        int underlineY = ins.top + 5 + fm.getAscent() + 3;
        g.drawLine(x, underlineY, x + (this.getWidth() - (x + ins.left + 5)), underlineY);
        int bottom = this.getComponentCount() == 0 ? this.getHeight() - this.getInsets().bottom : this.getHeight() - this.getInsets().bottom - this.getComponents()[0].getPreferredSize().height;
        int first = 0;
        int stop = steps2.length;
        boolean bl = wontFit = (y += h + 10) + h * steps2.length > this.getHeight();
        if (wontFit) {
            int availHeight = bottom - y;
            int willFit = availHeight / h;
            int currStepIndex = Arrays.asList(steps2).indexOf(currentStep);
            int rangeStart = Math.max(0, currStepIndex - willFit / 2);
            int rangeEnd = Math.min(rangeStart + willFit, steps2.length);
            if (rangeStart + willFit > steps2.length) {
                rangeStart = steps2.length - willFit;
                rangeEnd = steps2.length;
            }
            steps2 = (String[])steps2.clone();
            if (rangeStart != 0) {
                steps2[rangeStart] = this.elipsis;
                first = rangeStart;
            }
            if (rangeEnd != steps2.length && rangeEnd > 0) {
                steps2[rangeEnd - 1] = this.elipsis;
                stop = rangeEnd;
            }
        }
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        for (int i = first; i < stop; ++i) {
            boolean selected;
            boolean canOnlyFinish;
            boolean isUndetermined = "_#UndeterminedStep".equals(steps2[i]);
            boolean bl2 = canOnlyFinish = this.wizard.getForwardNavigationMode() == 2;
            if (isUndetermined && canOnlyFinish) break;
            String curr = !this.elipsis.equals(steps2[i]) ? (this.inSummaryPage && i == this.steps.length ? i + 1 + ". " + steps2[i] : i + 1 + ". " + (isUndetermined ? this.elipsis : (steps2[i].equals(this.elipsis) ? this.elipsis : this.wizard.getStepDescription(steps2[i])))) : this.elipsis;
            if (curr == null) continue;
            boolean bl3 = selected = steps2[i].equals(currentStep) && !this.inSummaryPage || this.inSummaryPage && i == steps2.length - 1;
            if (selected) {
                g.setFont(boldFont);
            }
            int width = fm.stringWidth(curr);
            while (width > this.getWidth() - (ins.left + ins.right) && curr.length() > 5) {
                curr = curr.substring(0, curr.length() - 5) + this.elipsis;
            }
            g.drawString(curr, x, y);
            if (selected) {
                g.setFont(f);
            }
            y += h;
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        BufferedImage image;
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        Graphics g = this.getGraphics();
        if (g == null) {
            g = new BufferedImage(1, 1, 2).getGraphics();
        }
        f = f.deriveFont(1);
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        int h = fm.getHeight();
        String[] steps2 = this.wizard.getAllSteps();
        int w = Integer.MIN_VALUE;
        for (int i = 0; i < steps2.length; ++i) {
            String desc = i + ". " + ("_#UndeterminedStep".equals(steps2[i]) ? this.elipsis : this.wizard.getStepDescription(steps2[i]));
            if (desc == null) continue;
            w = Math.max(w, fm.stringWidth(desc) + 5);
        }
        if (Integer.MIN_VALUE == w) {
            w = 250;
        }
        if ((image = this.getImage()) != null) {
            w = Math.max(w, image.getWidth());
        }
        this.historicWidth = w = Math.max(w, this.historicWidth);
        return new Dimension(w, ins.top + ins.bottom + (h + 3) * steps2.length);
    }

    @Override
    public void setInSummaryPage(boolean val) {
        this.inSummaryPage = val;
        this.repaint();
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void stepsChanged(Wizard wizard) {
        this.repaint();
    }

    @Override
    public void navigabilityChanged(Wizard wizard) {
    }

    @Override
    public void selectionChanged(Wizard wizard) {
        this.repaint();
    }

    @Override
    public final void doLayout() {
        Component[] c = this.getComponents();
        Insets ins = this.getInsets();
        int y = this.getHeight() - (5 + ins.bottom);
        int x = 5 + ins.left;
        int w = this.getWidth() - (10 + ins.left + ins.right);
        if (w < 0) {
            w = 0;
        }
        for (int i = c.length - 1; i >= 0; --i) {
            Dimension d = c[i].getPreferredSize();
            c[i].setBounds(x, y - d.height, w, d.height);
            y -= d.height;
        }
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        return new ACI(this);
    }

    private static final class ACI
    extends AccessibleContext {
        private final Wizard wizard;
        private final InstructionsPanelImpl panel;
        JEditorPane pane;

        public ACI(InstructionsPanelImpl pnl) {
            this.wizard = pnl.wizard;
            this.panel = pnl;
            if (pnl.getParent() instanceof Accessible) {
                this.setAccessibleParent((Accessible)((Object)pnl.getParent()));
            }
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (this.pane == null) {
                this.pane = new JEditorPane();
                this.pane.setBounds(this.panel.getBounds());
                this.pane.getAccessibleContext().getAccessibleText();
                this.pane.setFont(this.panel.getFont());
                CellRendererPane cell = new CellRendererPane();
                cell.add(this.pane);
            }
            this.pane.setText(this.getText());
            this.pane.selectAll();
            this.pane.validate();
            return this.pane.getAccessibleContext().getAccessibleText();
        }

        public String getText() {
            String[] s;
            StringBuilder sb = new StringBuilder();
            for (String item : s = this.wizard.getAllSteps()) {
                sb.append(this.wizard.getStepDescription(item)).append('\n');
            }
            return sb.toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleState[] states = new AccessibleState[]{AccessibleState.VISIBLE, AccessibleState.OPAQUE, AccessibleState.SHOWING, AccessibleState.MULTI_LINE};
            return new AccessibleStateSet(states);
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            throw new IndexOutOfBoundsException("" + i);
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }
}

