/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.func.NonFunction;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.ui.SwingUtils$$Lambda$1;

public class SwingUtils {
    private static final Map<Integer, Object> INVOKE_AND_WAIT_MAP = Collections.synchronizedMap(new HashMap());
    private static int INVOKE_AND_WAIT_ID = 0;
    private static final Object INVOKE_AND_WAIT_LOCK = new Object();

    public static DefaultTableModel makeDefaultTableModel(String[] titleA, final Class[] typesA, final boolean[] canEditA) {
        return new DefaultTableModel(new Object[0][], titleA){
            Class[] types;
            boolean[] canEdit;
            {
                super(x0, x1);
                this.types = typesA;
                this.canEdit = canEditA;
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    public static void openFolder(File f) {
        f.mkdirs();
        String path = f.getAbsolutePath();
        switch (OS.os()) {
            case OSX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                }
                catch (IOException ex) {
                    HMCLog.err("Failed to open " + path + " through /usr/bin/open", ex);
                }
                break;
            }
            default: {
                try {
                    Desktop.getDesktop().open(f);
                    break;
                }
                catch (Throwable ex) {
                    MessageBox.Show(C.i18n("message.cannot_open_explorer", new Object[0]) + ex.getMessage());
                    HMCLog.warn("Failed to open " + path + " through java.awt.Desktop.getDesktop().open()", ex);
                }
            }
        }
    }

    public static void openLink(String link) {
        if (link == null) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(link));
        }
        catch (Throwable e) {
            if (OS.os() == OS.OSX) {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", link});
                }
                catch (IOException ex) {
                    HMCLog.warn("Failed to open link: " + link, ex);
                }
            }
            HMCLog.warn("Failed to open link: " + link, e);
        }
    }

    public static void moveEnd(JTextArea tf) {
        int position = tf.getText().length();
        tf.setCaretPosition(position);
    }

    public static void moveEnd(JScrollPane pane) {
        JScrollBar bar = pane.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
    }

    public static DefaultListModel getDefaultListModel(JList list) {
        return (DefaultListModel)list.getModel();
    }

    public static void appendLast(JList list, Object element) {
        SwingUtils.getDefaultListModel(list).addElement(element);
    }

    public static void replaceLast(JList list, Object element) {
        DefaultListModel model = SwingUtils.getDefaultListModel(list);
        model.set(model.getSize() - 1, element);
    }

    public static void clear(JList list) {
        list.setModel(new DefaultListModel());
    }

    public static DefaultTableModel clearDefaultTable(JTable table) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        return model;
    }

    public static void appendLast(JTable table, Object ... elements) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.addRow(elements);
    }

    public static void setValueAt(JTable table, Object element, int row, int col) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.setValueAt(element, row, col);
    }

    public static Object[] getValueBySelectedRow(JTable table, int[] rows, int col) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        Object[] ret = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            ret[i] = model.getValueAt(rows[i], col);
        }
        return ret;
    }

    public static void removeRow(JTable table, int row) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.removeRow(row);
    }

    public static String getParsedJPanelText(JLabel jLabel1, String longString) {
        if (StrUtils.isBlank(longString)) {
            return longString;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = longString.toCharArray();
        FontMetrics fontMetrics = jLabel1.getFontMetrics(jLabel1.getFont());
        int beginIndex = 0;
        int limit = 1;
        while (beginIndex + limit <= chars.length) {
            if (fontMetrics.charsWidth(chars, beginIndex, limit) < jLabel1.getWidth()) {
                if (beginIndex + limit >= chars.length) {
                    builder.append(chars, beginIndex, limit);
                    break;
                }
            } else {
                builder.append(chars, beginIndex, limit - 1).append("<br/>");
                beginIndex += limit - 1;
                limit = 1;
            }
            ++limit;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeAndWait(NonFunction<T> x) {
        int id;
        Object object = INVOKE_AND_WAIT_LOCK;
        synchronized (object) {
            id = ++INVOKE_AND_WAIT_ID;
        }
        int fuck = id;
        Runnable r = SwingUtils$$Lambda$1.lambdaFactory$(fuck, x);
        SwingUtils.invokeAndWait(r);
        return (T)INVOKE_AND_WAIT_MAP.remove(id);
    }

    public static void invokeAndWait(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                HMCLog.err("Failed to invokeAndWait, the UI will work abnormally.", e);
                r.run();
            }
        }
    }

    public static int select(String[] selList, String msg) {
        Object[] msgs = new Object[]{msg, new JComboBox<String>(selList)};
        int result = JOptionPane.showOptionDialog(null, msgs, msg, 2, 3, null, null, null);
        if (result == 2) {
            return -1;
        }
        return ((JComboBox)msgs[1]).getSelectedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(JComponent component, boolean t) {
        Object object = component.getTreeLock();
        synchronized (object) {
            for (Component c : component.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                SwingUtils.setEnabled((JComponent)c, t);
            }
        }
        component.setEnabled(t);
    }

    public static void exitIfNoWindow(Window thisFrame) {
        SwingUtils.exitIfNoWindow(thisFrame, false);
    }

    public static void exitIfNoWindow(Window thisFrame, boolean neededDispose) {
        boolean flag = false;
        for (Window f : Window.getWindows()) {
            if (f == thisFrame || !f.isVisible()) continue;
            flag = true;
        }
        if (!flag) {
            try {
                Utils.shutdownForcely(0);
            }
            catch (Exception e) {
                MessageBox.Show(C.i18n("launcher.exit_failed", new Object[0]));
                HMCLog.err("Failed to shutdown forcely", e);
            }
        } else {
            thisFrame.dispose();
        }
    }

    public static ImageIcon scaleImage(ImageIcon i, int x, int y) {
        return new ImageIcon(i.getImage().getScaledInstance(x, y, 4));
    }

    public static ImageIcon searchBackgroundImage(ImageIcon init, String bgpath, int width, int height) {
        String[] backgroundPath;
        File backgroundImageFile;
        String[] backgroundPath2;
        Random r = new Random();
        boolean loaded = false;
        ImageIcon background = init;
        if (StrUtils.isNotBlank(bgpath) && !loaded && (backgroundPath2 = bgpath.split(";")).length > 0) {
            int index = r.nextInt(backgroundPath2.length);
            background = new ImageIcon(Toolkit.getDefaultToolkit().getImage(backgroundPath2[index]).getScaledInstance(width, height, 1));
            HMCLog.log("Prepared background image in bgpath.");
            loaded = true;
        }
        if (!loaded && (backgroundImageFile = new File("bg")).exists() && backgroundImageFile.isDirectory() && (backgroundPath = backgroundImageFile.list()).length > 0) {
            int index = r.nextInt(backgroundPath.length);
            background = new ImageIcon(Toolkit.getDefaultToolkit().getImage("bg" + File.separator + backgroundPath[index]).getScaledInstance(width, height, 1));
            HMCLog.log("Prepared background image in bgskin folder.");
            loaded = true;
        }
        if (!loaded && (backgroundImageFile = new File("background.png")).exists()) {
            loaded = true;
            background = new ImageIcon(Toolkit.getDefaultToolkit().getImage(backgroundImageFile.getAbsolutePath()).getScaledInstance(width, height, 1));
            HMCLog.log("Prepared background image in background.png.");
        }
        if (!loaded && (backgroundImageFile = new File("background.jpg")).exists()) {
            background = new ImageIcon(Toolkit.getDefaultToolkit().getImage(backgroundImageFile.getAbsolutePath()).getScaledInstance(width, height, 1));
            HMCLog.log("Prepared background image in background.jpg.");
        }
        if (background == null) {
            return init;
        }
        return background;
    }

    static /* synthetic */ void access$lambda$0(int n, NonFunction nonFunction) {
        SwingUtils.INVOKE_AND_WAIT_MAP.put(n, nonFunction.apply());
    }
}

