/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.DoubleOutputStream;
import org.jackhuang.hellominecraft.util.LauncherPrintStream;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.func.NonFunction;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.logging.Level;
import org.jackhuang.hellominecraft.util.ui.LogWindowOutputStream;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class LogWindow
extends JFrame {
    boolean movingEnd;
    NonFunction<Boolean> listener;
    Runnable terminateGameListener;
    public static final LogWindow INSTANCE = new LogWindow();
    private JButton btnClear;
    private JButton btnClose;
    private JButton btnCopy;
    private JButton btnGitHub;
    private JButton btnMCBBS;
    private JButton btnMCF;
    private JButton btnTerminateGame;
    private JButton btnTieBa;
    private JScrollPane jScrollPane2;
    private JLabel lblCrash;
    private JTextPane txtLog;

    public LogWindow() {
        this.initComponents();
        this.movingEnd = true;
        this.setLocationRelativeTo(null);
        this.txtLog.setEditable(false);
        DoubleOutputStream out = new DoubleOutputStream(new LogWindowOutputStream(this, Level.INFO), System.out);
        System.setOut(new LauncherPrintStream(out));
        DoubleOutputStream err = new DoubleOutputStream(new LogWindowOutputStream(this, Level.ERROR), System.err);
        System.setErr(new LauncherPrintStream(err));
    }

    private void initComponents() {
        this.btnClear = new JButton();
        this.btnClose = new JButton();
        this.btnCopy = new JButton();
        this.lblCrash = new JLabel();
        this.btnMCBBS = new JButton();
        this.btnTieBa = new JButton();
        this.btnMCF = new JButton();
        this.btnTerminateGame = new JButton();
        this.btnGitHub = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.txtLog = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(C.i18n("logwindow.title", new Object[0]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogWindow.this.formWindowClosing(evt);
            }
        });
        this.btnClear.setText(C.i18n("ui.button.clear", new Object[0]));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnClearActionPerformed(evt);
            }
        });
        this.btnClose.setText(C.i18n("ui.button.close", new Object[0]));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnCopy.setText(C.i18n("ui.button.copy", new Object[0]));
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnCopyActionPerformed(evt);
            }
        });
        this.lblCrash.setText(C.i18n("ui.label.crashing", new Object[0]));
        this.btnMCBBS.setText("MCBBS");
        this.btnMCBBS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnMCBBSActionPerformed(evt);
            }
        });
        this.btnTieBa.setText(C.i18n("logwindow.tieba", new Object[0]));
        this.btnTieBa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnTieBaActionPerformed(evt);
            }
        });
        this.btnMCF.setText("Minecraft Forum");
        this.btnMCF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnMCFActionPerformed(evt);
            }
        });
        this.btnTerminateGame.setText(C.i18n("logwindow.terminate_game", new Object[0]));
        this.btnTerminateGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnTerminateGameActionPerformed(evt);
            }
        });
        this.btnGitHub.setText("GitHub");
        this.btnGitHub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.btnGitHubActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.txtLog);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.btnTieBa).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMCBBS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMCF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGitHub).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnTerminateGame).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose)).addComponent(this.lblCrash, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblCrash).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 356, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClear).addComponent(this.btnClose).addComponent(this.btnCopy).addComponent(this.btnMCBBS).addComponent(this.btnTieBa).addComponent(this.btnMCF).addComponent(this.btnTerminateGame).addComponent(this.btnGitHub)).addContainerGap()));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (this.listener != null && this.listener.apply().booleanValue() && this.terminateGameListener != null) {
            this.terminateGameListener.run();
        }
        SwingUtils.exitIfNoWindow(this, true);
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.txtLog.setText("");
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        Utils.setClipborad(this.txtLog.getText());
    }

    private void btnMCBBSActionPerformed(ActionEvent evt) {
        SwingUtils.openLink("http://www.mcbbs.net/thread-142335-1-1.html");
    }

    private void btnTieBaActionPerformed(ActionEvent evt) {
        SwingUtils.openLink("http://tieba.baidu.com/f?kw=hellominecraftlauncher");
    }

    private void btnMCFActionPerformed(ActionEvent evt) {
        SwingUtils.openLink("http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-tools/1265720-hello-minecraft-launcher-1-9-3-mc-1-7-4-auto");
    }

    private void btnTerminateGameActionPerformed(ActionEvent evt) {
        if (this.terminateGameListener != null) {
            this.terminateGameListener.run();
        }
    }

    private void btnGitHubActionPerformed(ActionEvent evt) {
        SwingUtils.openLink("https://github.com/huanghongxun/HMCL/issues");
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.listener != null && this.listener.apply().booleanValue() && this.terminateGameListener != null) {
            this.terminateGameListener.run();
        }
        SwingUtils.exitIfNoWindow(this);
    }

    public void log(String status) {
        this.log(status, Level.INFO);
    }

    public void warning(String status) {
        this.log(status, Level.WARN);
    }

    public synchronized void log(String status, Level c) {
        status = status.replace("\t", "    ");
        StyledDocument d = this.txtLog.getStyledDocument();
        SimpleAttributeSet sas = new SimpleAttributeSet();
        StyleConstants.setForeground(sas, c.COLOR);
        try {
            d.insertString(d.getLength(), status, sas);
        }
        catch (Exception ex) {
            HMCLog.err("Failed to insert \"" + status + "\" to " + d.getLength(), ex);
        }
        if (this.movingEnd) {
            int position = d.getLength();
            this.txtLog.setCaretPosition(position);
        }
    }

    public void setExit(NonFunction<Boolean> exit) {
        this.listener = exit;
    }

    public void setTerminateGame(Runnable l) {
        this.terminateGameListener = l;
    }

    public void clean() {
        this.txtLog.setText("");
    }

    public boolean getMovingEnd() {
        return this.movingEnd;
    }

    public void setMovingEnd(boolean b) {
        this.movingEnd = b;
    }

    @Override
    public void setVisible(boolean b) {
        this.lblCrash.setVisible(false);
        this.btnMCBBS.setVisible(false);
        this.btnTieBa.setVisible(false);
        this.btnMCF.setVisible(false);
        super.setVisible(b);
    }

    public void showAsCrashWindow(boolean out_date) {
        if (out_date) {
            this.lblCrash.setVisible(false);
            this.btnMCBBS.setVisible(false);
            this.btnTieBa.setVisible(false);
            this.btnMCF.setVisible(false);
            this.lblCrash.setText(C.i18n("ui.label.crashing_out_dated", new Object[0]));
        } else {
            this.lblCrash.setVisible(true);
            this.btnMCBBS.setVisible(true);
            this.btnTieBa.setVisible(true);
            this.btnMCF.setVisible(true);
            this.lblCrash.setText(C.i18n("ui.label.crashing", new Object[0]));
        }
        super.setVisible(true);
    }
}

