/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.tasks.DoingDoneListener;
import org.jackhuang.hellominecraft.util.tasks.Task;

public class TaskList
extends Thread {
    List<Task> taskQueue = Collections.synchronizedList(new LinkedList());
    ArrayList<Runnable> allDone = new ArrayList();
    ArrayList<DoingDoneListener<Task>> taskListener = new ArrayList();
    int totTask;
    boolean shouldContinue = true;
    ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(64);
    HashMap<Invoker, Future<?>> futures = new HashMap();
    HashSet<Invoker> invokers = new HashSet();

    public TaskList() {
        this.setDaemon(true);
    }

    public void clean() {
        this.shouldContinue = true;
        this.taskQueue.clear();
    }

    public void addAllDoneListener(Runnable l) {
        this.allDone.add(l);
    }

    public void addTaskListener(DoingDoneListener<Task> l) {
        this.taskListener.add(l);
    }

    public void addTask(Task task) {
        this.taskQueue.add(task);
    }

    public int taskCount() {
        return this.totTask;
    }

    private boolean processTasks(Collection<? extends Task> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        this.totTask += c.size();
        AtomicBoolean bool = new AtomicBoolean(true);
        CountDownLatch counter = new CountDownLatch(c.size());
        for (Task task : c) {
            if (task == null) continue;
            task.setParallelExecuting(true);
            Invoker thread = new Invoker(task, counter, bool);
            this.invokers.add(thread);
            if (this.EXECUTOR_SERVICE.isShutdown() || this.EXECUTOR_SERVICE.isTerminated()) continue;
            this.futures.put(thread, this.EXECUTOR_SERVICE.submit(thread));
        }
        try {
            counter.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bool.get();
    }

    private boolean executeTask(Task t) {
        if (!this.shouldContinue) {
            return false;
        }
        if (t == null) {
            return true;
        }
        Collection<Task> c = t.getDependTasks();
        if (c == null) {
            c = new HashSet<Task>();
        }
        HMCLog.log("Executing task: " + t.getInfo());
        for (DoingDoneListener<Task> d : t.getTaskListeners()) {
            d.onDoing(t, c);
        }
        for (DoingDoneListener<Task> d : this.taskListener) {
            d.onDoing(t, c);
        }
        t.areDependTasksSucceeded = this.processTasks(c);
        boolean flag = true;
        try {
            t.executeTask();
        }
        catch (Throwable e) {
            t.setFailReason(e);
            flag = false;
        }
        if (flag) {
            HMCLog.log((t.isAborted() ? "Task aborted: " : "Task finished: ") + t.getInfo());
            Collection<Task> at = t.getAfterTasks();
            if (at == null) {
                at = new HashSet<Task>();
            }
            for (DoingDoneListener<Task> d : t.getTaskListeners()) {
                d.onDone(t, at);
            }
            for (DoingDoneListener<Task> d : this.taskListener) {
                d.onDone(t, at);
            }
            this.processTasks(at);
        } else {
            HMCLog.err("Task failed: " + t.getInfo(), t.getFailReason());
            for (DoingDoneListener<Task> d : this.taskListener) {
                d.onFailed(t);
            }
            for (DoingDoneListener<Task> d : t.getTaskListeners()) {
                d.onFailed(t);
            }
        }
        return flag;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("TaskList");
        this.totTask = this.taskQueue.size();
        while (!this.taskQueue.isEmpty()) {
            this.executeTask(this.taskQueue.remove(0));
        }
        if (this.shouldContinue) {
            for (Runnable d : this.allDone) {
                d.run();
            }
        }
    }

    public boolean isEmpty() {
        return this.taskQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.shouldContinue = false;
        HashSet<Invoker> in = this.invokers;
        this.EXECUTOR_SERVICE.shutdown();
        while (!in.isEmpty()) {
            HashSet<Invoker> hashSet = in;
            synchronized (hashSet) {
                Invoker it = in.iterator().next();
                if (!it.task.abort() && this.futures.get(it) != null) {
                    this.futures.get(it).cancel(true);
                }
                in.remove(it);
            }
        }
        this.interrupt();
    }

    private class Invoker
    implements Runnable {
        Task task;
        CountDownLatch latch;
        AtomicBoolean bool;

        public Invoker(Task task, CountDownLatch latch, AtomicBoolean bool) {
            this.task = task;
            this.latch = latch;
            this.bool = bool;
        }

        @Override
        public void run() {
            if (!TaskList.this.executeTask(this.task)) {
                this.bool.set(false);
            }
            this.latch.countDown();
        }
    }
}

