/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.tasks;

import java.util.ArrayList;
import java.util.Collection;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.tasks.DoingDoneListener;
import org.jackhuang.hellominecraft.util.tasks.DoubleTask;
import org.jackhuang.hellominecraft.util.tasks.ProgressProviderListener;

public abstract class Task {
    protected boolean aborted = false;
    protected Throwable failReason = null;
    protected String tag;
    protected boolean parallelExecuting;
    ArrayList<DoingDoneListener<Task>> taskListener = new ArrayList();
    public boolean areDependTasksSucceeded;
    protected ProgressProviderListener ppl;

    public abstract void executeTask() throws Throwable;

    public boolean abort() {
        this.aborted = true;
        return false;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Throwable getFailReason() {
        return this.failReason;
    }

    protected void setFailReason(Throwable s) {
        this.failReason = s;
    }

    public Task setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public boolean isParallelExecuting() {
        return this.parallelExecuting;
    }

    public void setParallelExecuting(boolean parallelExecuting) {
        this.parallelExecuting = parallelExecuting;
    }

    public Task addTaskListener(DoingDoneListener<Task> l) {
        this.taskListener.add(l);
        return this;
    }

    public ArrayList<DoingDoneListener<Task>> getTaskListeners() {
        return this.taskListener;
    }

    public abstract String getInfo();

    public Collection<Task> getDependTasks() {
        return null;
    }

    public Collection<Task> getAfterTasks() {
        return null;
    }

    public Task setProgressProviderListener(ProgressProviderListener p) {
        this.ppl = p;
        return this;
    }

    public Task after(Task t) {
        return new DoubleTask(this, t);
    }

    public Task before(Task t) {
        return new DoubleTask(t, this);
    }

    public void runWithException() throws Throwable {
        Collection<Task> c = this.getDependTasks();
        if (c != null) {
            for (Task t : c) {
                t.runWithException();
            }
        }
        this.executeTask();
        c = this.getAfterTasks();
        if (c != null) {
            for (Task t : c) {
                t.runWithException();
            }
        }
    }

    public boolean run() {
        try {
            this.runWithException();
            return true;
        }
        catch (Throwable t) {
            HMCLog.err("Failed to execute task", t);
            return false;
        }
    }
}

