/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.JavaProcess;

public class ProcessThread
extends Thread {
    JavaProcess p;
    public final EventHandler<String> printlnEvent = new EventHandler(this);
    public final EventHandler<JavaProcess> stopEvent = new EventHandler(this);

    public ProcessThread(JavaProcess process) {
        this.p = process;
    }

    public JavaProcess getProcess() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ProcessMonitor");
        InputStreamReader br = null;
        try {
            int ch;
            InputStream in = this.p.getRawProcess().getInputStream();
            try {
                br = new InputStreamReader(in, System.getProperty("sun.jnu.encoding", "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                HMCLog.warn("Unsupported encoding: " + System.getProperty("sun.jnu.encoding", "UTF-8"), ex);
                br = new InputStreamReader(in);
            }
            String line = "";
            while (this.p.isRunning()) {
                int ch2;
                while ((ch2 = br.read()) != -1) {
                    if (ch2 == 10) {
                        this.printlnEvent.execute(line);
                        System.out.println("Minecraft: " + line);
                        this.p.getStdOutLines().add(line);
                        line = "";
                        continue;
                    }
                    line = line + (char)ch2;
                }
            }
            while ((ch = br.read()) != -1) {
                if (ch == 10) {
                    this.printlnEvent.execute(line);
                    System.out.println("Minecraft: " + line);
                    this.p.getStdOutLines().add(line);
                    line = "";
                    continue;
                }
                line = line + (char)ch;
            }
            this.stopEvent.execute(this.p);
            IOUtils.closeQuietly(br);
        }
        catch (Exception e) {
            HMCLog.err("An error occured when reading process stdout/stderr.", e);
        }
        finally {
            IOUtils.closeQuietly(br);
        }
    }
}

