/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.StringTokenizer;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;

public enum OS {
    LINUX('/', "linux"),
    WINDOWS('\\', "windows"),
    OSX('/', "osx"),
    UNKOWN('/', "universal");

    public final char fileSeparator;
    public final String checked_name;

    private OS(char fileSeparator, String n2) {
        this.fileSeparator = fileSeparator;
        this.checked_name = n2;
    }

    public static OS os() {
        String str = System.getProperty("os.name").toLowerCase();
        if (str.contains("win")) {
            return WINDOWS;
        }
        if (str.contains("mac")) {
            return OSX;
        }
        if (str.contains("solaris")) {
            return LINUX;
        }
        if (str.contains("sunos")) {
            return LINUX;
        }
        if (str.contains("linux")) {
            return LINUX;
        }
        if (str.contains("unix")) {
            return LINUX;
        }
        return UNKOWN;
    }

    public static long getTotalPhysicalMemory() {
        try {
            if (OS.os() == LINUX) {
                return OS.memoryInfoForLinux()[0] * 1024L;
            }
            OperatingSystemMXBean o = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return o.getTotalPhysicalMemorySize();
        }
        catch (Throwable t) {
            HMCLog.warn("Failed to get total physical memory size", t);
            return -1L;
        }
    }

    public static long[] memoryInfoForLinux() throws IOException {
        String str;
        File file = new File("/proc/meminfo");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        long[] result = new long[4];
        while ((str = br.readLine()) != null) {
            StringTokenizer token = new StringTokenizer(str);
            if (!token.hasMoreTokens()) continue;
            str = token.nextToken();
            if (!token.hasMoreTokens()) continue;
            if (str.equalsIgnoreCase("MemTotal:")) {
                result[0] = Long.parseLong(token.nextToken());
                continue;
            }
            if (str.equalsIgnoreCase("MemFree:")) {
                result[1] = Long.parseLong(token.nextToken());
                continue;
            }
            if (str.equalsIgnoreCase("SwapTotal:")) {
                result[2] = Long.parseLong(token.nextToken());
                continue;
            }
            if (!str.equalsIgnoreCase("SwapFree:")) continue;
            result[3] = Long.parseLong(token.nextToken());
        }
        return result;
    }

    public static String getLinuxReleaseVersion() throws IOException {
        return FileUtils.read(new File("/etc/issue"));
    }

    public static String getSystemVersion() {
        if (OS.os() == LINUX) {
            try {
                return OS.getLinuxReleaseVersion();
            }
            catch (IOException e) {
                HMCLog.warn("Failed to catch /etc/issue");
            }
        }
        return System.getProperty("os.name") + " (" + System.getProperty("os.arch") + "), " + System.getProperty("os.version");
    }
}

