/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.util.Arrays;
import java.util.HashSet;
import org.jackhuang.hellominecraft.util.CollectionUtils;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.logging.Level;
import org.jackhuang.hellominecraft.util.system.JavaProcess;
import org.jackhuang.hellominecraft.util.system.JavaProcessMonitor$$Lambda$1;
import org.jackhuang.hellominecraft.util.system.JavaProcessMonitor$$Lambda$2;
import org.jackhuang.hellominecraft.util.system.JavaProcessMonitor$$Lambda$3;
import org.jackhuang.hellominecraft.util.system.JavaProcessMonitor$$Lambda$4;
import org.jackhuang.hellominecraft.util.system.ProcessThread;

public class JavaProcessMonitor {
    private final HashSet<Thread> al = new HashSet();
    public final EventHandler<JavaProcess> stoppedEvent = new EventHandler(this);
    public final EventHandler<Integer> applicationExitedAbnormallyEvent = new EventHandler(this);
    public final EventHandler<Integer> jvmLaunchFailedEvent = new EventHandler(this);
    private final JavaProcess p;

    public JavaProcessMonitor(JavaProcess p) {
        this.p = p;
    }

    public JavaProcess getJavaProcess() {
        return this.p;
    }

    public void start() {
        ProcessThread a = new ProcessThread(this.p);
        a.stopEvent.register(JavaProcessMonitor$$Lambda$1.lambdaFactory$(this));
        a.start();
        this.al.add(a);
    }

    void processThreadStopped(ProcessThread t, boolean forceTermintate) {
        this.al.remove(t);
        this.al.removeAll(CollectionUtils.map(this.al, JavaProcessMonitor$$Lambda$2.lambdaFactory$()));
        if (this.al.isEmpty() || forceTermintate) {
            for (Thread a : this.al) {
                a.interrupt();
            }
            this.al.clear();
            this.stoppedEvent.execute(this.p);
        }
    }

    private static /* synthetic */ boolean lambda$processThreadStopped$7(Thread t1) {
        return !t1.isAlive();
    }

    private /* synthetic */ boolean lambda$start$6(Object sender, JavaProcess t) {
        HMCLog.log("Process exit code: " + t.getExitCode());
        if (t.getExitCode() != 0 || StrUtils.containsOne(t.getStdOutLines(), Arrays.asList("Unable to launch"), JavaProcessMonitor$$Lambda$3.lambdaFactory$())) {
            this.applicationExitedAbnormallyEvent.execute(t.getExitCode());
        }
        if (t.getExitCode() != 0 && StrUtils.containsOne(t.getStdOutLines(), Arrays.asList("Could not create the Java Virtual Machine.", "Error occurred during initialization of VM", "A fatal exception has occurred. Program will exit.", "Unable to launch"), JavaProcessMonitor$$Lambda$4.lambdaFactory$())) {
            this.jvmLaunchFailedEvent.execute(t.getExitCode());
        }
        this.processThreadStopped((ProcessThread)sender, false);
        return true;
    }

    private static /* synthetic */ boolean lambda$null$5(String x) {
        return Level.guessLevel(x, Level.INFO).lessOrEqual(Level.ERROR);
    }

    private static /* synthetic */ boolean lambda$null$4(String x) {
        return Level.guessLevel(x, Level.INFO).lessOrEqual(Level.ERROR);
    }

    static /* synthetic */ boolean access$lambda$0(JavaProcessMonitor javaProcessMonitor, Object object, JavaProcess javaProcess) {
        return javaProcessMonitor.lambda$start$6(object, javaProcess);
    }

    static /* synthetic */ boolean access$lambda$1(Thread thread) {
        return JavaProcessMonitor.lambda$processThreadStopped$7(thread);
    }

    static /* synthetic */ boolean access$lambda$2(String string) {
        return JavaProcessMonitor.lambda$null$4(string);
    }

    static /* synthetic */ boolean access$lambda$3(String string) {
        return JavaProcessMonitor.lambda$null$5(string);
    }
}

