/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jackhuang.hellominecraft.util.system.ProcessManager;

public class JavaProcess {
    private final List<String> commands;
    private final Process process;
    private final ArrayList<String> stdOutLines = new ArrayList();

    public JavaProcess(List<String> commands, Process process, ProcessManager pm) {
        this.commands = commands;
        this.process = process;
        if (pm != null) {
            pm.registerProcess(this);
        }
    }

    public JavaProcess(String[] commands, Process process, ProcessManager pm) {
        this(Arrays.asList(commands), process, pm);
    }

    public Process getRawProcess() {
        return this.process;
    }

    public List<String> getStartupCommands() {
        return this.commands;
    }

    public String getStartupCommand() {
        return this.process.toString();
    }

    public ArrayList<String> getStdOutLines() {
        return this.stdOutLines;
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
        return false;
    }

    public int getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            ex.fillInStackTrace();
            throw ex;
        }
    }

    public String toString() {
        return "JavaProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }

    public void stop() {
        this.process.destroy();
    }
}

