/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.OS;

public class Java {
    public static final List<Java> JAVA;
    String name;
    String home;

    public static Java suggestedJava() {
        for (Java j : JAVA) {
            if (!j.name.startsWith("1.8") && !j.name.startsWith("9")) continue;
            return j;
        }
        return JAVA.get(0);
    }

    public Java(String name, String home) {
        this.name = name;
        this.home = home;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        if (this.name.equals("Default")) {
            return C.i18n("settings.default", new Object[0]);
        }
        if (this.name.equals("Custom")) {
            return C.i18n("settings.custom", new Object[0]);
        }
        return this.name;
    }

    public String getHome() {
        return this.home;
    }

    public String getJava() {
        return IOUtils.getJavaDir(this.getHome());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Java) {
            Java j = (Java)obj;
            return j.getName() == null && this.getName() == null || ((Java)obj).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static List<Java> queryAllJDKInMac() {
        File f;
        ArrayList<Java> ans = new ArrayList<Java>();
        File jre = new File("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home");
        if (jre.exists()) {
            ans.add(new Java("JRE", jre.getPath()));
        }
        if ((f = new File("/Library/Java/JavaVirtualMachines/")).exists()) {
            for (File a : f.listFiles()) {
                ans.add(new Java(a.getName(), new File(a, "Contents/Home").getAbsolutePath()));
            }
        }
        return ans;
    }

    public static List<Java> queryAllJavaHomeInWindowsByReg() {
        ArrayList<Java> ans = new ArrayList<Java>();
        try {
            Java.queryJava(ans, "HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Runtime Environment");
            Java.queryJava(ans, "HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Development Kit");
        }
        catch (IOException | InterruptedException ex) {
            HMCLog.err("Faield to query java", ex);
        }
        return ans;
    }

    private static void queryJava(List<Java> ans, String location) throws IOException, InterruptedException {
        for (String java : Java.queryRegSubFolders(location)) {
            String javahome;
            int s = 0;
            for (char c : java.toCharArray()) {
                if (c != '.') continue;
                ++s;
            }
            if (s <= 1 || (javahome = Java.queryRegValue(java, "JavaHome")) == null) continue;
            ans.add(new Java(java.substring(location.length()), javahome));
        }
    }

    private static List<String> queryRegSubFolders(String location) throws IOException, InterruptedException {
        String[] cmd = new String[]{"cmd", "/c", "reg", "query", location};
        List<String> l = IOUtils.readProcessByInputStream(cmd);
        ArrayList<String> ans = new ArrayList<String>();
        for (String line : l) {
            if (!line.startsWith(location) || line.equals(location)) continue;
            ans.add(line);
        }
        return ans;
    }

    private static String queryRegValue(String location, String name) throws IOException, InterruptedException {
        String[] cmd = new String[]{"cmd", "/c", "reg", "query", location, "/v", name};
        List<String> l = IOUtils.readProcessByInputStream(cmd);
        boolean last = false;
        for (String s : l) {
            int begins;
            if (s.trim().isEmpty()) continue;
            if (last && s.trim().startsWith(name) && (begins = s.indexOf(name)) > 0 && (begins = (s = s.substring(begins + name.length())).indexOf("REG_SZ")) > 0) {
                s = s.substring(begins + "REG_SZ".length());
                return s.trim();
            }
            if (!s.trim().equals(location)) continue;
            last = true;
        }
        return null;
    }

    static {
        ArrayList<Java> temp = new ArrayList<Java>();
        temp.add(new Java("Default", System.getProperty("java.home")));
        temp.add(new Java("Custom", null));
        if (OS.os() == OS.WINDOWS) {
            temp.addAll(Java.queryAllJavaHomeInWindowsByReg());
        }
        if (OS.os() == OS.OSX) {
            temp.addAll(Java.queryAllJDKInMac());
        }
        JAVA = Collections.unmodifiableList(temp);
    }
}

