/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.JavaProcess;
import org.jackhuang.hellominecraft.util.system.OS;

public class IOUtils {
    public static String addSeparator(String path) {
        if (path == null || path.trim().length() == 0) {
            return "";
        }
        if (IOUtils.isSeparator(path.charAt(path.length() - 1))) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static String addURLSeparator(String path) {
        if (path == null || path.trim().length() == 0) {
            return "";
        }
        if (path.charAt(path.length() - 1) == '/') {
            return path;
        }
        return path + '/';
    }

    public static boolean isSeparator(char ch) {
        return ch == File.separatorChar || ch == '/' || ch == '\\';
    }

    public static String removeLastSeparator(String dir) {
        String t = dir.trim();
        char ch = t.charAt(t.length() - 1);
        if (IOUtils.isSeparator(ch)) {
            return t.substring(0, t.length() - 1);
        }
        return t;
    }

    public static String extractLastDirectory(String dir) {
        int i;
        String t = IOUtils.removeLastSeparator(dir);
        for (i = t.length() - 1; i >= 0 && !IOUtils.isSeparator(dir.charAt(i)); --i) {
        }
        if (i < 0) {
            return t;
        }
        return t.substring(i + 1, t.length() - i + (i + 1) - 1);
    }

    public static void findAllFile(File f, Consumer<String> callback) {
        if (f.isDirectory()) {
            File[] f1 = f.listFiles();
            int len = f1.length;
            for (int i = 0; i < len; ++i) {
                if (!f1[i].isFile()) continue;
                callback.accept(f1[i].getName());
            }
        }
    }

    public static void findAllDir(File f, Consumer<String> callback) {
        if (f.isDirectory()) {
            File[] f1 = f.listFiles();
            int len = f1.length;
            for (int i = 0; i < len; ++i) {
                if (!f1[i].isDirectory()) continue;
                callback.accept(f1[i].getName());
            }
        }
    }

    public static String getRealPath() {
        String realPath = IOUtils.class.getClassLoader().getResource("").getFile();
        File file = new File(realPath);
        realPath = file.getAbsolutePath();
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realPath;
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null) {
            return true;
        }
        return path.startsWith("/") || path.indexOf(":") > 0;
    }

    public static String getLocalMAC() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress();
            return IOUtils.getMacAddress(ip);
        }
        catch (UnknownHostException e) {
            HMCLog.warn("Failed to get local mac address because of the unknown host.", e);
            return "ERROR";
        }
    }

    public static String getMacAddress(String host) {
        String mac;
        StringBuilder sb = new StringBuilder();
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(host));
            byte[] macs = ni.getHardwareAddress();
            for (int i = 0; i < macs.length; ++i) {
                mac = Integer.toHexString(macs[i] & 0xFF);
                if (mac.length() == 1) {
                    mac = '0' + mac;
                }
                sb.append(mac).append("-");
            }
        }
        catch (SocketException e) {
            HMCLog.warn("Failed to get mac address because the socket has thrown an exception.", e);
        }
        catch (UnknownHostException e) {
            HMCLog.warn("Failed to get mac address because of the unknown host.", e);
        }
        mac = sb.toString();
        mac = mac.substring(0, mac.length() - 1);
        return mac;
    }

    public static String extractFileName(String fileName) {
        File file = new File(fileName);
        return file.getName();
    }

    public static String getJavaDir() {
        return IOUtils.getJavaDir(System.getProperty("java.home"));
    }

    public static String getJavaDir(String home) {
        String path = home + File.separatorChar + "bin" + File.separatorChar;
        path = IOUtils.addSeparator(path);
        if (OS.os() == OS.WINDOWS && new File(path + "javaw.exe").isFile()) {
            return path + "javaw.exe";
        }
        return path + "java";
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(String data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            output.write(data.getBytes(encoding));
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static String tryGetCanonicalFolderPath(File file) {
        try {
            return IOUtils.addSeparator(file.getCanonicalPath());
        }
        catch (IOException ignored) {
            return IOUtils.addSeparator(file.getAbsolutePath());
        }
    }

    public static File tryGetCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ignored) {
            return file.getAbsoluteFile();
        }
    }

    public static File tryGetCanonicalFile(String file) {
        return IOUtils.tryGetCanonicalFile(new File(file));
    }

    public static String tryGetCanonicalFilePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ignored) {
            return file.getAbsolutePath();
        }
    }

    public static URL parseURL(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException ex) {
            HMCLog.warn("Failed to parse URL:" + str);
            return null;
        }
    }

    public static List<String> readProcessByInputStream(String[] cmd) throws IOException, InterruptedException {
        JavaProcess jp = new JavaProcess(cmd, new ProcessBuilder(cmd).start(), null);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(jp.getRawProcess().getInputStream()));
        Throwable throwable = null;
        try {
            String line;
            jp.getRawProcess().waitFor();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (br != null) {
                if (throwable != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    br.close();
                }
            }
        }
        return lines;
    }

    public static List<String> readProcessByErrorStream(String[] cmd) throws IOException, InterruptedException {
        JavaProcess jp = new JavaProcess(cmd, new ProcessBuilder(cmd).start(), null);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(jp.getRawProcess().getErrorStream()));
        Throwable throwable = null;
        try {
            String line;
            jp.getRawProcess().waitFor();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (br != null) {
                if (throwable != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    br.close();
                }
            }
        }
        return lines;
    }
}

