/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.logging.logger;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jackhuang.hellominecraft.util.logging.Level;
import org.jackhuang.hellominecraft.util.logging.logger.AbstractLogger;
import org.jackhuang.hellominecraft.util.logging.message.IMessage;
import org.jackhuang.hellominecraft.util.logging.message.IMessageFactory;

public class SimpleLogger
extends AbstractLogger {
    private static final char SPACE = ' ';
    private DateFormat dateFormatter;
    private Level level;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private PrintStream stream;
    private final String logName;

    public SimpleLogger(String name, Level defaultLevel, boolean showLogName, boolean showShortLogName, boolean showDateTime, boolean showContextMap, String dateTimeFormat, IMessageFactory messageFactory, PrintStream stream) {
        super(name, messageFactory);
        int index;
        this.level = defaultLevel;
        this.logName = showShortLogName ? ((index = name.lastIndexOf(".")) > 0 && index < name.length() ? name.substring(index + 1) : name) : (showLogName ? name : null);
        this.showDateTime = showDateTime;
        this.showContextMap = showContextMap;
        this.stream = stream;
        if (showDateTime) {
            try {
                this.dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                this.dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
            }
        }
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abstractLog(Level level, IMessage msg, Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        if (this.showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = this.dateFormatter;
            synchronized (dateFormat) {
                dateText = this.dateFormatter.format(now);
            }
            sb.append(dateText);
            sb.append(' ');
        }
        sb.append(level.toString());
        sb.append(' ');
        if (this.logName != null && this.logName.length() > 0) {
            sb.append(this.logName);
            sb.append(' ');
        }
        sb.append(msg.getFormattedMessage());
        Object[] params = msg.getParameters();
        Throwable t = throwable == null && params != null && params[params.length - 1] instanceof Throwable ? (Throwable)params[params.length - 1] : throwable;
        if (t != null) {
            sb.append(' ');
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            sb.append(baos.toString());
        }
        this.stream.println(sb.toString());
    }

    @Override
    protected boolean isEnabled(Level level, String msg) {
        return this.level.level >= level.level;
    }

    @Override
    protected boolean isEnabled(Level level, String msg, Throwable t) {
        return this.level.level >= level.level;
    }

    @Override
    protected boolean isEnabled(Level level, String msg, Object[] p1) {
        return this.level.level >= level.level;
    }

    @Override
    protected boolean isEnabled(Level level, Object msg, Throwable t) {
        return this.level.level >= level.level;
    }

    @Override
    protected boolean isEnabled(Level level, IMessage msg, Throwable t) {
        return this.level.level >= level.level;
    }
}

