/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.logging.logger;

import org.jackhuang.hellominecraft.util.logging.Level;
import org.jackhuang.hellominecraft.util.logging.logger.ILogger;
import org.jackhuang.hellominecraft.util.logging.message.IMessage;
import org.jackhuang.hellominecraft.util.logging.message.IMessageFactory;
import org.jackhuang.hellominecraft.util.logging.message.ParameterizedMessageFactory;
import org.jackhuang.hellominecraft.util.logging.message.StringFormattedMessage;

public abstract class AbstractLogger
implements ILogger {
    public static final Class<? extends IMessageFactory> DEFAULT_MESSAGE_FACTORY_CLASS = ParameterizedMessageFactory.class;
    private static final String FQCN = AbstractLogger.class.getName();
    private static final String THROWING = "throwing";
    private static final String CATCHING = "catching";
    private final String name;
    private final IMessageFactory messageFactory;

    public AbstractLogger() {
        this.name = this.getClass().getName();
        this.messageFactory = this.createDefaultMessageFactory();
    }

    public AbstractLogger(String name) {
        this.name = name;
        this.messageFactory = this.createDefaultMessageFactory();
    }

    public AbstractLogger(String name, IMessageFactory messageFactory) {
        this.name = name;
        this.messageFactory = messageFactory == null ? this.createDefaultMessageFactory() : messageFactory;
    }

    private IMessageFactory createDefaultMessageFactory() {
        try {
            return DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void catching(Level level, Throwable t) {
        if (this.isEnabled(level, (Object)null, null)) {
            this.log(level, this.messageFactory.newMessage(CATCHING), t);
        }
    }

    @Override
    public void catching(Throwable t) {
        this.catching(Level.ERROR, t);
    }

    @Override
    public void debug(IMessage msg) {
        if (this.isEnabled(Level.DEBUG, msg, null)) {
            this.log(Level.DEBUG, msg, null);
        }
    }

    @Override
    public void debug(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.DEBUG, msg, t)) {
            this.log(Level.DEBUG, msg, t);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isEnabled(Level.DEBUG, message, null)) {
            this.log(Level.DEBUG, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, message, t)) {
            this.log(Level.DEBUG, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isEnabled(Level.DEBUG, message)) {
            this.log(Level.DEBUG, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void debug(String message, Object[] params) {
        if (this.isEnabled(Level.DEBUG, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.DEBUG, msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, message, t)) {
            this.log(Level.DEBUG, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void entry() {
        this.entry(new Object[0]);
    }

    @Override
    public void entry(Object[] params) {
        if (this.isEnabled(Level.TRACE, (Object)null, null)) {
            this.log(Level.TRACE, this.entryMsg(params.length, params), null);
        }
    }

    private IMessage entryMsg(int count, Object[] params) {
        if (count == 0) {
            return this.messageFactory.newMessage("entry");
        }
        StringBuilder sb = new StringBuilder("entry params(");
        int i = 0;
        for (Object parm : params) {
            if (parm != null) {
                sb.append(parm.toString());
            } else {
                sb.append("null");
            }
            if (++i >= params.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return this.messageFactory.newMessage(sb.toString());
    }

    @Override
    public void error(IMessage msg) {
        if (this.isEnabled(Level.ERROR, msg, null)) {
            this.log(Level.ERROR, msg, null);
        }
    }

    @Override
    public void error(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.ERROR, msg, t)) {
            this.log(Level.ERROR, msg, t);
        }
    }

    @Override
    public void error(Object message) {
        if (this.isEnabled(Level.ERROR, message, null)) {
            this.log(Level.ERROR, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.isEnabled(Level.ERROR, message, t)) {
            this.log(Level.ERROR, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void error(String message) {
        if (this.isEnabled(Level.ERROR, message)) {
            this.log(Level.ERROR, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void error(String message, Object[] params) {
        if (this.isEnabled(Level.ERROR, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.ERROR, msg, msg.getThrowable());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isEnabled(Level.ERROR, message, t)) {
            this.log(Level.ERROR, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void fatal(IMessage msg) {
        if (this.isEnabled(Level.FATAL, msg, null)) {
            this.log(Level.FATAL, msg, null);
        }
    }

    @Override
    public void fatal(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.FATAL, msg, t)) {
            this.log(Level.FATAL, msg, t);
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.isEnabled(Level.FATAL, message, null)) {
            this.log(Level.FATAL, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.isEnabled(Level.FATAL, message, t)) {
            this.log(Level.FATAL, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void fatal(String message) {
        if (this.isEnabled(Level.FATAL, message)) {
            this.log(Level.FATAL, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void fatal(String message, Object[] params) {
        if (this.isEnabled(Level.FATAL, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.FATAL, msg, msg.getThrowable());
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.isEnabled(Level.FATAL, message, t)) {
            this.log(Level.FATAL, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void info(IMessage msg) {
        if (this.isEnabled(Level.INFO, msg, null)) {
            this.log(Level.INFO, msg, null);
        }
    }

    @Override
    public void info(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.INFO, msg, t)) {
            this.log(Level.INFO, msg, t);
        }
    }

    @Override
    public void info(Object message) {
        if (this.isEnabled(Level.INFO, message, null)) {
            this.log(Level.INFO, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.isEnabled(Level.INFO, message, t)) {
            this.log(Level.INFO, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void info(String message) {
        if (this.isEnabled(Level.INFO, message)) {
            this.log(Level.INFO, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void info(String message, Object[] params) {
        if (this.isEnabled(Level.INFO, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.INFO, msg, msg.getThrowable());
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.isEnabled(Level.INFO, message, t)) {
            this.log(Level.INFO, this.messageFactory.newMessage(message), t);
        }
    }

    protected abstract boolean isEnabled(Level var1, IMessage var2, Throwable var3);

    protected abstract boolean isEnabled(Level var1, Object var2, Throwable var3);

    protected abstract boolean isEnabled(Level var1, String var2);

    protected abstract boolean isEnabled(Level var1, String var2, Object[] var3);

    protected abstract boolean isEnabled(Level var1, String var2, Throwable var3);

    protected abstract void abstractLog(Level var1, IMessage var2, Throwable var3);

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.isEnabled(level, (Object)null, null);
    }

    @Override
    public void log(Level level, IMessage msg) {
        if (this.isEnabled(level, msg, null)) {
            this.log(level, msg, null);
        }
    }

    @Override
    public void log(Level level, IMessage msg, Throwable t) {
        if (this.isEnabled(level, msg, t)) {
            this.abstractLog(level, msg, t);
        }
    }

    @Override
    public void log(Level level, Object message) {
        if (this.isEnabled(level, message, null)) {
            this.log(level, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void log(Level level, Object message, Throwable t) {
        if (this.isEnabled(level, message, t)) {
            this.log(level, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void log(Level level, String message) {
        if (this.isEnabled(level, message)) {
            this.log(level, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void log(Level level, String message, Object[] params) {
        if (this.isEnabled(level, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(level, msg, msg.getThrowable());
        }
    }

    @Override
    public void log(Level level, String message, Throwable t) {
        if (this.isEnabled(level, message, t)) {
            this.log(level, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void printf(Level level, String format, Object[] params) {
        if (this.isEnabled(level, format, params)) {
            StringFormattedMessage msg = new StringFormattedMessage(format, params);
            this.log(level, msg, msg.getThrowable());
        }
    }

    @Override
    public <T extends Throwable> T throwing(T t) {
        return this.throwing(Level.ERROR, t);
    }

    @Override
    public <T extends Throwable> T throwing(Level level, T t) {
        if (this.isEnabled(level, (Object)null, null)) {
            this.log(level, this.messageFactory.newMessage(THROWING), t);
        }
        return t;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void trace(IMessage msg) {
        if (this.isEnabled(Level.TRACE, msg, null)) {
            this.log(Level.TRACE, msg, null);
        }
    }

    @Override
    public void trace(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.TRACE, msg, t)) {
            this.log(Level.TRACE, msg, t);
        }
    }

    @Override
    public void trace(Object message) {
        if (this.isEnabled(Level.TRACE, message, null)) {
            this.log(Level.TRACE, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.isEnabled(Level.TRACE, message, t)) {
            this.log(Level.TRACE, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void trace(String message) {
        if (this.isEnabled(Level.TRACE, message)) {
            this.log(Level.TRACE, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void trace(String message, Object[] params) {
        if (this.isEnabled(Level.TRACE, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.TRACE, msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.isEnabled(Level.TRACE, message, t)) {
            this.log(Level.TRACE, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void warn(IMessage msg) {
        if (this.isEnabled(Level.WARN, msg, null)) {
            this.log(Level.WARN, msg, null);
        }
    }

    @Override
    public void warn(IMessage msg, Throwable t) {
        if (this.isEnabled(Level.WARN, msg, t)) {
            this.log(Level.WARN, msg, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isEnabled(Level.WARN, message, null)) {
            this.log(Level.WARN, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.isEnabled(Level.WARN, message, t)) {
            this.log(Level.WARN, this.messageFactory.newMessage(message), t);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isEnabled(Level.WARN, message)) {
            this.log(Level.WARN, this.messageFactory.newMessage(message), null);
        }
    }

    @Override
    public void warn(String message, Object[] params) {
        if (this.isEnabled(Level.WARN, message, params)) {
            IMessage msg = this.messageFactory.newMessage(message, params);
            this.log(Level.WARN, msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isEnabled(Level.WARN, message, t)) {
            this.log(Level.WARN, this.messageFactory.newMessage(message), t);
        }
    }
}

