/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.logging.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jackhuang.hellominecraft.util.logging.LogEvent;
import org.jackhuang.hellominecraft.util.logging.LoggingException;
import org.jackhuang.hellominecraft.util.logging.appender.AbstractAppender;
import org.jackhuang.hellominecraft.util.logging.layout.ILayout;

public abstract class OutputStreamAppender
extends AbstractAppender {
    protected final OutputStream stream;
    protected final boolean immediateFlush;
    private final Lock readLock = new ReentrantReadWriteLock().readLock();

    public OutputStreamAppender(String name, ILayout<? extends Serializable> layout, boolean ignoreExceptions, OutputStream stream, boolean immediateFlush) {
        super(name, layout, ignoreExceptions);
        this.immediateFlush = immediateFlush;
        this.stream = stream;
    }

    @Override
    public void append(LogEvent event) {
        this.readLock.lock();
        try {
            byte[] bytes = this.getLayout().toByteArray(event);
            if (bytes.length > 0) {
                this.stream.write(bytes);
            }
            if (event.thrown != null) {
                event.thrown.printStackTrace(new PrintStream(this.stream));
            }
        }
        catch (IOException ex) {
            System.err.println("Unable to write to stream for appender: " + this.getName());
            throw new LoggingException(ex);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

