/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.lang;

import java.util.Locale;
import org.jackhuang.hellominecraft.util.lang.Localization;

public enum SupportedLocales {
    def(Locale.getDefault(), "lang.default"),
    en(Locale.ENGLISH, null),
    zh_TW(Locale.TRADITIONAL_CHINESE, null),
    zh_CN(Locale.SIMPLIFIED_CHINESE, null);

    public Locale self;
    private String showString;
    private String customized;
    private Localization bundle;
    public static SupportedLocales NOW_LOCALE;

    private SupportedLocales(Locale self, String customized) {
        this.self = self;
        try {
            this.bundle = Localization.get(self);
            this.showString = this.bundle.localize("lang");
            this.customized = customized;
        }
        catch (Throwable t) {
            this.showString = this.name();
            t.printStackTrace();
        }
    }

    public String showString() {
        if (this.customized == null) {
            return this.showString;
        }
        return NOW_LOCALE.translate(this.customized, new Object[0]);
    }

    public String translate(String key, Object ... format) {
        try {
            return String.format(this.bundle.localize(key), format);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return key;
        }
    }

    static {
        NOW_LOCALE = def;
    }
}

