/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public final class Utils {
    public static boolean isURL(String s) {
        try {
            new URL(s);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static URL[] getURL() {
        return ((URLClassLoader)Utils.class.getClassLoader()).getURLs();
    }

    public static int getSuggestedMemorySize() {
        try {
            OperatingSystemMXBean osmb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            int memory = (int)(osmb.getTotalPhysicalMemorySize() / 1024L / 1024L) / 4;
            memory = Math.round((float)memory / 128.0f) * 128;
            return memory;
        }
        catch (Throwable t) {
            HMCLog.warn("Failed to get total memory size, use 1024MB.", t);
            return 1024;
        }
    }

    public static void setClipborad(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static void shutdownForcely(int status) throws Exception {
        Class<?> z = Class.forName("java.lang.Shutdown");
        Method exit = z.getDeclaredMethod("exit", Integer.TYPE);
        exit.setAccessible(true);
        exit.invoke(z, status);
    }

    public static void requireNonNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Oh dear, there is a problem...");
        }
    }

    public static Object firstNonNull(Object ... o) {
        for (Object s : o) {
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

