/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.jackhuang.hellominecraft.util.MathUtils;
import org.jackhuang.hellominecraft.util.StrUtils$$Lambda$1;
import org.jackhuang.hellominecraft.util.StrUtils$$Lambda$2;
import org.jackhuang.hellominecraft.util.func.Function;
import org.jackhuang.hellominecraft.util.func.Predicate;

public final class StrUtils {
    public static String substring(String src, int start_idx, int end_idx) {
        byte[] b = src.getBytes();
        String tgt = "";
        for (int i = start_idx; i <= end_idx; ++i) {
            tgt = tgt + (char)b[i];
        }
        return tgt;
    }

    public static String makeCommand(List<String> cmd) {
        StringBuilder cmdbuf = new StringBuilder(120);
        for (int i = 0; i < cmd.size(); ++i) {
            String s;
            if (i > 0) {
                cmdbuf.append(' ');
            }
            if ((s = cmd.get(i)).indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    cmdbuf.append('\"');
                    cmdbuf.append(s);
                    if (s.endsWith("\\")) {
                        cmdbuf.append("\\");
                    }
                    cmdbuf.append('\"');
                    continue;
                }
                if (s.endsWith("\"")) {
                    cmdbuf.append(s);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            cmdbuf.append(s);
        }
        String str = cmdbuf.toString();
        return str;
    }

    public static boolean startsWith(String base, String match) {
        return base != null && base.startsWith(match);
    }

    public static boolean startsWithOne(String[] a, String match) {
        if (a == null) {
            return false;
        }
        for (String b : a) {
            if (!StrUtils.startsWith(match, b)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithOne(Collection<String> a, String match) {
        if (a == null) {
            return false;
        }
        for (String b : a) {
            if (!StrUtils.startsWith(match, b)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(String base, String ... a) {
        for (String s : a) {
            if (!base.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOne(String base, String ... match) {
        for (String s : match) {
            if (!base.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOne(List<String> base, List<String> match) {
        for (String a : base) {
            for (String b : match) {
                if (!a.toLowerCase().contains(b.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOne(List<String> base, List<String> match, Predicate<String> pred) {
        for (String a : base) {
            for (String b : match) {
                if (!pred.apply(a) || !a.toLowerCase().contains(b.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCharShowTime(String s, char c) {
        int res = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++res;
        }
        return res;
    }

    public static String formatVersion(String ver) {
        if (StrUtils.isBlank(ver)) {
            return null;
        }
        for (char ch : ver.toCharArray()) {
            if (ch >= '0' && ch <= '9' || ch == '.') continue;
            return null;
        }
        int i = StrUtils.getCharShowTime(ver, '.');
        if (i == 1) {
            return ver + ".0";
        }
        return ver;
    }

    public static String parseParams(String addBefore, Collection paramArrayOfObject, String paramString) {
        return StrUtils.parseParams(addBefore, paramArrayOfObject.toArray(), paramString);
    }

    public static String parseParams(String addBefore, Object[] params, String addAfter) {
        return StrUtils.parseParams(StrUtils$$Lambda$1.lambdaFactory$(addBefore), params, StrUtils$$Lambda$2.lambdaFactory$(addAfter));
    }

    public static String parseParams(Function<Object, String> beforeFunc, Object[] params, Function<Object, String> afterFunc) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            String addBefore = beforeFunc.apply(param);
            String addAfter = afterFunc.apply(param);
            if (i > 0) {
                sb.append(addAfter).append(addBefore);
            }
            if (param == null) {
                sb.append("null");
                continue;
            }
            if (param.getClass().isArray()) {
                sb.append("[");
                if (param instanceof Object[]) {
                    Object[] objs = (Object[])param;
                    sb.append(StrUtils.parseParams(beforeFunc, objs, afterFunc));
                } else {
                    for (int j = 0; j < Array.getLength(param); ++j) {
                        if (j > 0) {
                            sb.append(addAfter);
                        }
                        sb.append(addBefore).append(Array.get(param, j));
                    }
                }
                sb.append("]");
                continue;
            }
            sb.append(addBefore).append(params[i]);
        }
        return sb.toString();
    }

    public static boolean isEquals(String base, String to) {
        if (base == null) {
            return to == null;
        }
        return base.equals(to);
    }

    public static Dimension parseDimension(String str) {
        String[] tokenized = StrUtils.tokenize(str, "x,");
        if (tokenized.length != 2) {
            return null;
        }
        int i = MathUtils.parseInt(tokenized[0], -1);
        int j = MathUtils.parseInt(tokenized[1], -1);
        if (i < 0 || j < 0) {
            return null;
        }
        return new Dimension(i, j);
    }

    public static String[] tokenize(String paramString1) {
        return StrUtils.tokenize(paramString1, " \t\n\r\f");
    }

    public static String[] tokenize(String paramString1, String paramString2) {
        ArrayList<String> localArrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(paramString1, paramString2);
        while (tokenizer.hasMoreTokens()) {
            paramString2 = tokenizer.nextToken();
            localArrayList.add(paramString2);
        }
        return localArrayList.toArray(new String[localArrayList.size()]);
    }

    public static String trimExtension(String filename) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length()) {
            return filename.substring(0, i);
        }
        return filename;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isNotBlank(String s) {
        return !StrUtils.isBlank(s);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter trace = new StringWriter();
        PrintWriter writer = new PrintWriter(trace);
        t.printStackTrace(writer);
        return trace.toString();
    }

    static /* synthetic */ String access$lambda$0(String string, Object object) {
        return string;
    }

    static /* synthetic */ String access$lambda$1(String string, Object object) {
        return string;
    }
}

