/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;

public final class NetUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static byte[] getBytesFromStream(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
        byte[] arrayOfByte1 = new byte[1024];
        while ((i = is.read(arrayOfByte1)) >= 0) {
            localByteArrayOutputStream.write(arrayOfByte1, 0, i);
        }
        is.close();
        return localByteArrayOutputStream.toByteArray();
    }

    public static String getStreamContent(InputStream is) throws IOException {
        return NetUtils.getStreamContent(is, DEFAULT_CHARSET);
    }

    public static String getStreamContent(InputStream is, String encoding) throws IOException {
        if (is == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        InputStreamReader br = new InputStreamReader(is, encoding);
        Throwable throwable = null;
        try {
            int len;
            char[] buf = new char[16384];
            while ((len = br.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (br != null) {
                if (throwable != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    br.close();
                }
            }
        }
        return sb.toString();
    }

    public static String get(String url, String encoding) throws IOException {
        return NetUtils.getStreamContent(new URL(url).openConnection().getInputStream());
    }

    public static String get(String url) throws IOException {
        return NetUtils.get(url, DEFAULT_CHARSET);
    }

    public static String get(URL url) throws IOException {
        return NetUtils.get(url, Proxy.NO_PROXY);
    }

    public static String get(URL url, Proxy proxy) throws IOException {
        return NetUtils.getStreamContent(url.openConnection(proxy).getInputStream());
    }

    public static String post(URL u, Map<String, String> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return NetUtils.post(u, sb.toString());
    }

    public static String post(URL u, String post) throws IOException {
        return NetUtils.post(u, post, "application/x-www-form-urlencoded");
    }

    public static String post(URL u, String post, String contentType) throws IOException {
        return NetUtils.post(u, post, contentType, Proxy.NO_PROXY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(URL u, String post, String contentType, Proxy proxy) throws IOException {
        String result;
        HttpURLConnection con = (HttpURLConnection)u.openConnection(proxy);
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        con.setConnectTimeout(30000);
        con.setReadTimeout(30000);
        con.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        byte[] bytes = post.getBytes(DEFAULT_CHARSET);
        con.setRequestProperty("Content-Length", "" + bytes.length);
        con.connect();
        OutputStream os = null;
        try {
            os = con.getOutputStream();
            IOUtils.write(bytes, os);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
        InputStream is = null;
        try {
            is = con.getInputStream();
            result = NetUtils.getStreamContent(is);
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(is);
            is = con.getErrorStream();
            result = NetUtils.getStreamContent(is);
        }
        con.disconnect();
        return result;
    }

    public static URL constantURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            HMCLog.err("Failed to get url instance: " + url, ex);
            return null;
        }
    }

    public static URL concatenateURL(URL url, String query) {
        try {
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + "&" + query);
            }
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + "?" + query);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", ex);
        }
    }
}

