/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jackhuang.hellominecraft.util.func.Predicate;

public final class CollectionUtils {
    public static <T> ArrayList<T> map(Collection<T> coll, Predicate<T> p) {
        ArrayList<T> newColl = new ArrayList<T>();
        for (T t : coll) {
            if (!p.apply(t)) continue;
            newColl.add(t);
        }
        return newColl;
    }

    public static <T> boolean removeIf(Collection<T> coll, Predicate<T> p) {
        boolean removed = false;
        Iterator<T> each = coll.iterator();
        while (each.hasNext()) {
            if (!p.apply(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

