/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.lookandfeel.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.jackhuang.hellominecraft.lookandfeel.ui.ScrollButton;
import org.jackhuang.hellominecraft.util.ui.GraphicsUtils;

public class ScrollBarUI
extends MetalScrollBarUI {
    private static final BufferedImage BACKGROUND_ENABLED = GraphicsUtils.loadImage("scroll_enabled.png");
    private static final BufferedImage BACKGROUND_DISABLED = GraphicsUtils.loadImage("scroll_disabled.png");
    private static final BufferedImage SCROLL_DEC_NORMAL = GraphicsUtils.loadImage("scroll_dec_normal.png");
    private static final BufferedImage SCROLL_DEC_OVER = GraphicsUtils.loadImage("scroll_dec_over.png");
    private static final BufferedImage SCROLL_DEC_PRESSED = GraphicsUtils.loadImage("scroll_dec_pressed.png");
    private static final BufferedImage SCROLL_INC_NORMAL = GraphicsUtils.loadImage("scroll_inc_normal.png");
    private static final BufferedImage SCROLL_INC_OVER = GraphicsUtils.loadImage("scroll_inc_over.png");
    private static final BufferedImage SCROLL_INC_PRESSED = GraphicsUtils.loadImage("scroll_inc_pressed.png");
    private static final BufferedImage SCROLL_THUMB_NORMAL = GraphicsUtils.loadImage("scroll_thumb_normal.png");
    private static final BufferedImage SCROLL_THUMB_OVER = GraphicsUtils.loadImage("scroll_thumb_over.png");
    private static final BufferedImage SCROLL_THUMB_PRESSED = GraphicsUtils.loadImage("scroll_thumb_pressed.png");
    private boolean incBtnMouseOver;
    private boolean incBtnMousePressed;
    private boolean decBtnMouseOver;
    private boolean decBtnMousePressed;
    private boolean thumbMousePressed;

    public static ComponentUI createUI(JComponent c) {
        return new ScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ScrollBarUI.this.isThumbRollover()) {
                    ScrollBarUI.this.thumbMousePressed = true;
                    ScrollBarUI.this.scrollbar.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScrollBarUI.this.thumbMousePressed = false;
            }
        });
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(15, 15);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new ScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        this.decreaseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ScrollBarUI.this.decBtnMouseOver = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ScrollBarUI.this.decBtnMouseOver = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollBarUI.this.decBtnMousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScrollBarUI.this.decBtnMousePressed = false;
            }
        });
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new ScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        this.increaseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ScrollBarUI.this.incBtnMouseOver = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ScrollBarUI.this.incBtnMouseOver = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollBarUI.this.incBtnMousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScrollBarUI.this.incBtnMousePressed = false;
            }
        });
        return this.increaseButton;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        BufferedImage decImg;
        BufferedImage bufferedImage = this.decBtnMousePressed ? SCROLL_DEC_PRESSED : (decImg = this.decBtnMouseOver ? SCROLL_DEC_OVER : SCROLL_DEC_NORMAL);
        BufferedImage incImg = this.incBtnMousePressed ? SCROLL_INC_PRESSED : (this.incBtnMouseOver ? SCROLL_INC_OVER : SCROLL_INC_NORMAL);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform origTransform = g2.getTransform();
        int scrollWidth = this.scrollbar.getWidth();
        if (this.scrollbar.getOrientation() == 1) {
            scrollWidth = this.scrollbar.getHeight();
            g2.scale(1.0, -1.0);
            g2.rotate(-1.5707963267948966, 0.0, 0.0);
        }
        if (this.scrollbar.isEnabled()) {
            g.drawImage(decImg, 0, 0, this.scrollbar);
            g.drawImage(incImg, scrollWidth - 15, 0, this.scrollbar);
        }
        g2.setTransform(origTransform);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (this.scrollbar.isEnabled()) {
            BufferedImage thumbImg = this.thumbMousePressed ? SCROLL_THUMB_PRESSED : (this.isThumbRollover() ? SCROLL_THUMB_OVER : SCROLL_THUMB_NORMAL);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform origTransform = g2.getTransform();
            Rectangle b = thumbBounds;
            if (this.scrollbar.getOrientation() == 1) {
                b = new Rectangle(thumbBounds.y, thumbBounds.x, thumbBounds.height, thumbBounds.width);
                g2.scale(1.0, -1.0);
                g2.rotate(-1.5707963267948966, 0.0, 0.0);
            }
            g.drawImage(thumbImg, b.x, b.y, b.x + 14, b.y + 15, 0, 0, 14, 15, this.scrollbar);
            g.drawImage(thumbImg, b.x + 14, b.y, b.x + b.width - 14, b.y + 15, 16, 0, 17, 15, this.scrollbar);
            g.drawImage(thumbImg, b.x + b.width - 14, b.y, b.x + b.width, b.y + 15, 24, 0, 38, 15, this.scrollbar);
            g2.setTransform(origTransform);
        }
    }
}

