/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.lookandfeel.painter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jackhuang.hellominecraft.util.ui.GraphicsUtils;

public class ProgressPainter
extends SynthPainter {
    private static final float[] NORMAL_BG_PTS = new float[]{0.0f, 1.0f};
    private static final Color[] NORMAL_BG = new Color[]{GraphicsUtils.getWebColor("c6c6c6"), GraphicsUtils.getWebColor("c6c6c6")};
    private static final float[] BAR_FG_PTS = new float[]{0.0f, 1.0f};
    private static final Color[] BAR_FG = new Color[]{GraphicsUtils.getWebColor("41B1E1"), GraphicsUtils.getWebColor("41B1E1")};

    @Override
    public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 4, NORMAL_BG_PTS, NORMAL_BG));
        if (x + 2 < w - 5 && y + 2 < h - 5) {
            g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        }
    }

    @Override
    public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new LinearGradientPaint(x, y + 2, x, y + h - 2, BAR_FG_PTS, BAR_FG));
        if (x + 2 < w - 5 && y + 2 < h - 5) {
            g2.fillRect(x + 2, y + 2, w - 5, h - 5);
        }
    }

    @Override
    public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
    }
}

