/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util;

import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.lang.SupportedLocales;

public final class MinecraftCrashAdvicer {
    public static String getAdvice(String trace) {
        return MinecraftCrashAdvicer.getAdvice(trace, false);
    }

    public static String getAdvice(String trace, boolean selfCrash) {
        if (trace == null) {
            return C.i18n("crash.advice.no", new Object[0]);
        }
        if ((trace = trace.toLowerCase(SupportedLocales.NOW_LOCALE.self)).contains("pixel format not accelerated")) {
            return C.i18n("crash.advice.LWJGLException", new Object[0]);
        }
        if (trace.contains("unsupportedclassversionrrror")) {
            return C.i18n("crash.advice.UnsupportedClassVersionError", new Object[0]);
        }
        if (trace.contains("concurrentmodificationexception")) {
            return C.i18n("crash.advice.ConcurrentModificationException", new Object[0]);
        }
        if (trace.contains("securityexception")) {
            return C.i18n("crash.advice.SecurityException", new Object[0]);
        }
        if (trace.contains("nosuchfieldexception") || trace.contains("nosuchfielderror")) {
            return C.i18n("crash.advice.NoSuchFieldError", new Object[0]);
        }
        if (trace.contains("outofmemory") || trace.contains("out of memory")) {
            return C.i18n("crash.advice.OutOfMemoryError", new Object[0]);
        }
        if (trace.contains("noclassdeffounderror") || trace.contains("classnotfoundexception")) {
            return C.i18n("crash.advice.ClassNotFoundException", new Object[0]);
        }
        if (trace.contains("no lwjgl in java.library.path")) {
            return C.i18n("crash.advice.no_lwjgl", new Object[0]);
        }
        if (trace.contains("opengl") || trace.contains("openal")) {
            return C.i18n("crash.advice.OpenGL", new Object[0]);
        }
        return C.i18n(selfCrash ? "crash.advice.no" : "crash.advice.otherwise", new Object[0]);
    }
}

