/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui.modpack;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.launcher.setting.Config;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.modpack.ModpackDescriptionPanel;
import org.jackhuang.hellominecraft.launcher.ui.modpack.ModpackFileSelectionPanel;
import org.jackhuang.hellominecraft.launcher.ui.modpack.ModpackInitializationPanel;
import org.jackhuang.hellominecraft.launcher.ui.modpack.ModpackWizard$1$1$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.Pair;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.ZipEngine;
import org.jackhuang.hellominecraft.util.ui.WebPage;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeNode;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.DeferredWizardResult;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.ResultProgressHandle;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Summary;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardBranchController;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardController;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardException;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardPanelProvider;
import org.markdown4j.Markdown4jProcessor;

public class ModpackWizard
extends WizardBranchController {
    static void process(CheckBoxTreeNode node, String basePath, List<String> list) {
        if (node == null) {
            return;
        }
        if (node.isSelected()) {
            if (basePath.length() > "minecraft/".length()) {
                list.add(basePath.substring("minecraft/".length()));
            }
            return;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            CheckBoxTreeNode n = (CheckBoxTreeNode)e.nextElement();
            String s = n.getUserObject() instanceof Pair ? (String)((Pair)n.getUserObject()).key : n.getUserObject().toString();
            ModpackWizard.process(n, basePath + "/" + s, list);
        }
    }

    public ModpackWizard(final Profile profile) {
        super(new WizardPanelProvider(C.i18n("modpack.wizard", new Object[0]), new String[]{C.i18n("modpack.wizard.step.1", new Object[0]), C.i18n("modpack.wizard.step.2", new Object[0]), C.i18n("modpack.wizard.step.3", new Object[0])}, new String[]{C.i18n("modpack.wizard.step.1.title", new Object[0]), C.i18n("modpack.wizard.step.2.title", new Object[0]), C.i18n("modpack.wizard.step.3.title", new Object[0])}){

            @Override
            protected Object finish(Map settings) throws WizardException {
                return new DeferredWizardResult(false){

                    @Override
                    public void start(Map settings, ResultProgressHandle progress) {
                        progress.setBusy("Processing modpack");
                        ArrayList<String> blackList = new ArrayList<String>(ModpackManager.MODPACK_BLACK_LIST);
                        CheckBoxTreeNode root = (CheckBoxTreeNode)settings.get("blackList");
                        ModpackWizard.process(root, "minecraft", blackList);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("name", (String)settings.get("modpackName"));
                        if (settings.containsKey("modpackDescription")) {
                            try {
                                map.put("description", new Markdown4jProcessor().process((String)settings.get("modpackDescription")));
                            }
                            catch (Exception ex) {
                                progress.failed(C.i18n("modpack.export_error", new Object[0]) + ": " + StrUtils.getStackTrace(ex), true);
                            }
                        }
                        try {
                            File loc;
                            String gameVersion = (String)settings.get("gameVersion");
                            String strLocation = (String)settings.get("modpackLocation");
                            if (!strLocation.endsWith(".zip")) {
                                strLocation = strLocation + ".zip";
                            }
                            File modpack = loc = new File(strLocation);
                            if (((Boolean)settings.get("launcher")).booleanValue()) {
                                modpack = new File(loc.getAbsolutePath() + ".temp");
                            }
                            ModpackManager.export(modpack, profile.service().version(), gameVersion, blackList, map, ModpackWizard$1$1$$Lambda$1.lambdaFactory$(profile, gameVersion));
                            String summary = "<html>" + C.i18n("modpack.export_finished", new Object[0]) + ": " + loc.getAbsolutePath();
                            boolean including = false;
                            if (((Boolean)settings.get("launcher")).booleanValue()) {
                                boolean flag = true;
                                ZipEngine engine = new ZipEngine(loc);
                                Config s = new Config();
                                if (!IOUtils.isAbsolutePath(Settings.getInstance().getBgpath())) {
                                    s.setBgpath(Settings.getInstance().getBgpath());
                                }
                                s.setDownloadType(Settings.getInstance().getDownloadType());
                                engine.putTextFile(C.GSON.toJson(s), "hmcl.json");
                                engine.putFile(modpack, "modpack.zip");
                                File bg = new File("bg");
                                if (bg.isDirectory()) {
                                    engine.putDirectory(bg);
                                }
                                if ((bg = new File("background.png")).isFile()) {
                                    engine.putFile(bg, "background.png");
                                }
                                if ((bg = new File("background.jpg")).isFile()) {
                                    engine.putFile(bg, "background.jpg");
                                }
                                for (URL u : Utils.getURL()) {
                                    try {
                                        File f = new File(u.toURI());
                                        if (!f.getName().endsWith(".exe") && !f.getName().endsWith(".jar")) continue;
                                        engine.putFile(f, f.getName());
                                    }
                                    catch (Exception e) {
                                        HMCLog.err("Failed to add launcher files.", e);
                                        flag = false;
                                        break;
                                    }
                                }
                                engine.closeFile();
                                if (flag) {
                                    including = true;
                                    if (!modpack.delete()) {
                                        HMCLog.warn("Failed to delete modpack.zip.temp, maybe the file is in using.");
                                    }
                                }
                            }
                            summary = summary + "<br/>" + C.i18n(including ? "modpack.included_launcher" : "modpack.not_included_launcher", new Object[0]) + "</html>";
                            progress.finished(new Summary(new WebPage(summary), null));
                        }
                        catch (IOException | GameException ex) {
                            HMCLog.err("Failed to export modpack", ex);
                            progress.failed(C.i18n("modpack.export_error", new Object[0]) + ": " + StrUtils.getStackTrace(ex), true);
                        }
                    }

                    static /* synthetic */ void access$lambda$0(Profile profile, String string, ZipEngine zipEngine) {
                        zipEngine.putTextFile(C.GSON.toJson(((HMCLMinecraftService)profile.service()).getVersionSetting(string)), "minecraft/hmclversion.cfg");
                    }
                };
            }

            @Override
            protected JComponent createPanel(WizardController controller, String id, Map settings) {
                switch (this.indexOfStep(id)) {
                    case 0: {
                        Vector<String> s = new Vector<String>(profile.service().version().getVersionCount());
                        for (MinecraftVersion v : profile.service().version().getVersions()) {
                            if (v.hidden) continue;
                            s.add(v.id);
                        }
                        controller.setForwardNavigationMode(1);
                        return new ModpackInitializationPanel(controller, settings, s, profile.getSelectedVersion());
                    }
                    case 1: {
                        controller.setForwardNavigationMode(3);
                        return new ModpackFileSelectionPanel(controller, settings, profile.service().baseDirectory(), ModpackManager.MODPACK_PREDICATE);
                    }
                    case 2: {
                        controller.setForwardNavigationMode(2);
                        return new ModpackDescriptionPanel(controller, settings);
                    }
                }
                throw new IllegalArgumentException(id);
            }
        });
    }

    @Override
    protected WizardPanelProvider getPanelProviderForStep(String step, Map settings) {
        return null;
    }
}

