/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui.modpack;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardController;

public class ModpackInitializationPanel
extends JPanel {
    public static final String KEY_GAME_VERSION = "gameVersion";
    public static final String KEY_MODPACK_LOCATION = "modpackLocation";
    public static final String KEY_MODPACK_NAME = "modpackName";
    public static final String KEY_INCLUDING_LAUNCHER = "launcher";
    private final transient WizardController controller;
    private final Map wizardData;
    static final Pattern PATTERN = Pattern.compile("[-a-zA-Z0-9_\\.\\(\\)\\[\\]\\{\\}\\<\\>\"'\u4e00-\u9fa5]+$");
    private JComboBox<String> cboGameVersion;
    private JButton cboModpackLocation;
    private JCheckBox chkIncludeLauncher;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblGameVersion;
    private JLabel lblModpackLocation;
    private JTextField txtModpackLocation;
    private JTextField txtModpackName;

    public ModpackInitializationPanel(WizardController controller, Map wizardData, Vector<String> versions, String selVersion) {
        this.initComponents();
        this.controller = controller;
        this.wizardData = wizardData;
        wizardData.put(KEY_GAME_VERSION, versions);
        wizardData.put("selVersion", selVersion);
        wizardData.put(KEY_INCLUDING_LAUNCHER, false);
        this.configureComboContents();
        this.checkProblem();
    }

    private void configureComboContents() {
        Vector versions = (Vector)this.wizardData.get(KEY_GAME_VERSION);
        this.cboGameVersion.setModel(new DefaultComboBoxModel(versions));
        this.wizardData.put(KEY_GAME_VERSION, this.wizardData.get("selVersion"));
    }

    private void initComponents() {
        this.lblModpackLocation = new JLabel();
        this.txtModpackLocation = new JTextField();
        this.cboModpackLocation = new JButton();
        this.lblGameVersion = new JLabel();
        this.cboGameVersion = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtModpackName = new JTextField();
        this.chkIncludeLauncher = new JCheckBox();
        this.lblModpackLocation.setText(C.i18n("modpack.wizard.step.initialization.save", new Object[0]));
        this.txtModpackLocation.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ModpackInitializationPanel.this.txtModpackLocationCaretUpdate(evt);
            }
        });
        this.cboModpackLocation.setText("...");
        this.cboModpackLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModpackInitializationPanel.this.cboModpackLocationActionPerformed(evt);
            }
        });
        this.lblGameVersion.setText(C.i18n("modpack.wizard.step.initialization.exported_version", new Object[0]));
        this.cboGameVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ModpackInitializationPanel.this.cboGameVersionItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(C.i18n("modpack.wizard.step.initialization.warning", new Object[0]));
        this.jLabel2.setText(C.i18n("modpack.name", new Object[0]));
        this.txtModpackName.setToolTipText("");
        this.txtModpackName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ModpackInitializationPanel.this.txtModpackNameCaretUpdate(evt);
            }
        });
        this.chkIncludeLauncher.setText(C.i18n("modpack.wizard.step.initialization.include_launcher", new Object[0]));
        this.chkIncludeLauncher.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ModpackInitializationPanel.this.chkIncludeLauncherItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtModpackName).addGroup(layout.createSequentialGroup().addComponent(this.lblModpackLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 353, Short.MAX_VALUE).addComponent(this.cboModpackLocation)).addComponent(this.txtModpackLocation).addComponent(this.cboGameVersion, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGameVersion).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.chkIncludeLauncher)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtModpackName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblModpackLocation).addComponent(this.cboModpackLocation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtModpackLocation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblGameVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboGameVersion, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeLauncher).addContainerGap()));
    }

    private void cboModpackLocationActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(C.i18n("modpack.wizard.step.initialization.save", new Object[0]));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileNameExtensionFilter(C.i18n("modpack", new Object[0]) + "(*.zip)", "zip"));
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String path = fc.getSelectedFile().getAbsolutePath();
            if (!path.endsWith(".zip")) {
                path = path + ".zip";
            }
            this.txtModpackLocation.setText(path);
        }
    }

    private void txtModpackLocationCaretUpdate(CaretEvent evt) {
        this.wizardData.put(KEY_MODPACK_LOCATION, this.txtModpackLocation.getText());
        this.checkProblem();
    }

    private void cboGameVersionItemStateChanged(ItemEvent evt) {
        this.wizardData.put(KEY_GAME_VERSION, this.cboGameVersion.getSelectedItem());
    }

    private void txtModpackNameCaretUpdate(CaretEvent evt) {
        this.wizardData.put(KEY_MODPACK_NAME, this.txtModpackName.getText());
        this.checkProblem();
    }

    private void chkIncludeLauncherItemStateChanged(ItemEvent evt) {
        this.wizardData.put(KEY_INCLUDING_LAUNCHER, this.chkIncludeLauncher.isSelected());
    }

    void checkProblem() {
        this.controller.setProblem(null);
        if (this.txtModpackLocation.getText().trim().isEmpty()) {
            this.controller.setProblem(C.i18n("modpack.not_a_valid_location", new Object[0]));
        }
        if (!PATTERN.matcher(this.txtModpackName.getText()).matches()) {
            this.controller.setProblem(C.i18n("modpack.not_a_valid_name", new Object[0]));
        }
    }
}

