/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui.modpack;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.Pair;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeCellRenderer;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeNode;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeNodeSelectionListener;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardController;

public class ModpackFileSelectionPanel
extends JPanel {
    private final transient WizardController controller;
    private final Map wizardData;
    private final transient BiFunction<String, Boolean, Integer> blackList;
    private final Set<String> bannedFiles = new HashSet<String>();
    private static final HashMap<String, String> TRANSLATION = new HashMap<String, String>(){
        {
            this.put("minecraft/servers.dat", C.i18n("modpack.files.servers_dat", new Object[0]));
            this.put("minecraft/saves", C.i18n("modpack.files.saves", new Object[0]));
            this.put("minecraft/mods", C.i18n("modpack.files.mods", new Object[0]));
            this.put("minecraft/config", C.i18n("modpack.files.config", new Object[0]));
            this.put("minecraft/liteconfig", C.i18n("modpack.files.liteconfig", new Object[0]));
            this.put("minecraft/resourcepacks", C.i18n("modpack.files.resourcepacks", new Object[0]));
            this.put("minecraft/options.txt", C.i18n("modpack.files.options_txt", new Object[0]));
            this.put("minecraft/optionsshaders.txt", C.i18n("modpack.files.optionsshaders_txt", new Object[0]));
            this.put("minecraft/mods/VoxelMods", C.i18n("modpack.files.mods.voxelmods", new Object[0]));
            this.put("minecraft/dumps", C.i18n("modpack.files.dumps", new Object[0]));
            this.put("minecraft/blueprints", C.i18n("modpack.files.blueprints", new Object[0]));
            this.put("minecraft/scripts", C.i18n("modpack.files.scripts", new Object[0]));
        }
    };
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public ModpackFileSelectionPanel(WizardController controller, Map wizardData, File gameDir, BiFunction<String, Boolean, Integer> blackList) {
        this.initComponents();
        this.controller = controller;
        this.wizardData = wizardData;
        this.blackList = blackList;
        CheckBoxTreeNode root = this.create(gameDir, "minecraft");
        this.jTree1.setModel(new DefaultTreeModel(root));
        this.jTree1.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.jTree1.addMouseListener(new CheckBoxTreeNodeSelectionListener());
        wizardData.put("blackList", root);
    }

    CheckBoxTreeNode create(File file, String basePath) {
        int state = 0;
        if (basePath.length() > "minecraft/".length() && (state = this.blackList.apply(basePath.substring("minecraft/".length()) + (file.isDirectory() ? "/" : ""), file.isDirectory()).intValue()) == 1) {
            return null;
        }
        CheckBoxTreeNode node = new CheckBoxTreeNode(TRANSLATION.containsKey(basePath) ? new Pair<String, String>(FileUtils.getName(basePath), TRANSLATION.get(basePath)) : FileUtils.getName(basePath));
        if (state == 2) {
            node.setSelected(true);
        }
        if (file.isDirectory()) {
            File[] f;
            for (File subFile : f = file.listFiles()) {
                CheckBoxTreeNode subNode = this.create(subFile, basePath + "/" + subFile.getName());
                if (subNode == null) continue;
                subNode.setSelected(subNode.isSelected() | node.isSelected());
                node.add(subNode);
            }
            if (!node.children().hasMoreElements()) {
                return null;
            }
        }
        return node;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
    }
}

