/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;

public final class NewProfileWindow
extends JDialog {
    private JButton btnCancel;
    private JButton btnOK;
    private JComboBox cboProfiles;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField txtNewProfileName;

    public NewProfileWindow(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(null);
        for (Profile s : Settings.getProfilesFiltered()) {
            this.cboProfiles.addItem(s.getName());
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtNewProfileName = new JTextField();
        this.jLabel2 = new JLabel();
        this.cboProfiles = new JComboBox();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(C.i18n("ui.newProfileWindow.title", new Object[0]));
        this.jLabel1.setText(C.i18n("ui.label.newProfileWindow.new_profile_name", new Object[0]));
        this.txtNewProfileName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewProfileWindow.this.txtNewProfileNameKeyTyped(evt);
            }
        });
        this.jLabel2.setText(C.i18n("ui.label.newProfileWindow.copy_from", new Object[0]));
        this.btnCancel.setText(C.i18n("button.cancel", new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProfileWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOK.setText(C.i18n("ui.button.ok", new Object[0]));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProfileWindow.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNewProfileName)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboProfiles, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 262, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtNewProfileName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cboProfiles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOK)).addContainerGap()));
        this.pack();
    }

    private void txtNewProfileNameKeyTyped(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 13: {
                this.act();
                break;
            }
            case 27: {
                this.dispose();
                break;
            }
        }
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.act();
    }

    void act() {
        if (!StrUtils.isBlank(this.txtNewProfileName.getText())) {
            Profile newProfile = new Profile(this.txtNewProfileName.getText(), Settings.getProfile(this.cboProfiles.getSelectedItem().toString()));
            Settings.putProfile(newProfile);
        }
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

