/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$10;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$4;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$5;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$6;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$7;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$8;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel$$Lambda$9;
import org.jackhuang.hellominecraft.launcher.ui.modpack.ModpackWizard;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService;
import org.jackhuang.hellominecraft.lookandfeel.comp.ConstomButton;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.Event;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.ui.GraphicsUtils;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;
import org.jackhuang.hellominecraft.util.ui.wizard.api.WizardDisplayer;

public class MainPagePanel
extends AnimatedPanel {
    boolean preparingAuth = true;
    private boolean isLoading = false;
    private JPanel pnlButtons;
    private ConstomButton btnRun;
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 480;
    private JButton btnExportModpack;
    private JButton btnImportModpack;
    private JButton btnLogout;
    private JComboBox cboLoginMode;
    private JComboBox cboProfiles;
    private JComboBox cboVersions;
    private JLabel jLabel10;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JLabel lblUserName;
    private JLabel lblVersion;
    private JPanel pnlMore;
    private JPanel pnlPassword;
    private JPasswordField txtPassword;
    private JTextField txtPlayerName;
    final Event<IAuthenticator> onAuthChanged = MainPagePanel$$Lambda$1.lambdaFactory$(this);
    final Runnable onLoadingProfiles = MainPagePanel$$Lambda$2.lambdaFactory$(this);
    final Consumer<IMinecraftService> onRefreshedVersions = MainPagePanel$$Lambda$3.lambdaFactory$(this);
    boolean showedNoVersion = false;
    final Consumer<Boolean> launchingStateChanged = MainPagePanel$$Lambda$4.lambdaFactory$();
    final Consumer<String> versionChanged = MainPagePanel$$Lambda$5.lambdaFactory$(this);
    final Consumer<Profile> onSelectedProfilesChanged = MainPagePanel$$Lambda$6.lambdaFactory$(this);

    void initGui() {
        this.initComponents();
        this.pnlButtons = new JPanel();
        this.pnlButtons.setLayout(null);
        int w = 150;
        int h = 50;
        this.btnRun = new ConstomButton();
        this.btnRun.setBounds(0, 0, w, h);
        Font font = this.btnRun.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), 15);
        this.pnlButtons.add(this.btnRun);
        this.btnRun.setText(C.i18n("ui.button.run", new Object[0]));
        this.btnRun.setFont(newFont);
        this.btnRun.addActionListener(MainPagePanel$$Lambda$7.lambdaFactory$());
        this.add(this.pnlButtons);
        this.pnlButtons.setBounds(0, 0, w, h);
        this.setSize(new Dimension(800, 480));
        this.pnlButtons.setLocation(800 - this.pnlButtons.getWidth() - 25, 480 - this.pnlButtons.getHeight() - 25);
        this.pnlMore.setBounds(0, 0, this.pnlMore.getWidth(), 480);
        this.pnlMore.setBackground(GraphicsUtils.getWebColorWithAlpha("FFFFFF7F"));
        this.pnlMore.setOpaque(true);
        Settings.getInstance().authChangedEvent.register(this.onAuthChanged);
        Settings.profileLoadingEvent.register(this.onLoadingProfiles);
        Settings.profileChangedEvent.register(this.onSelectedProfilesChanged);
        MainFrame.INSTANCE.daemon.customizedSuccessEvent = MainPagePanel$$Lambda$8.lambdaFactory$(this);
        this.prepareAuths();
        this.animationEnabled = false;
    }

    private void initComponents() {
        this.pnlMore = new JPanel();
        this.txtPlayerName = new JTextField();
        this.jLabel7 = new JLabel();
        this.cboLoginMode = new JComboBox();
        this.lblUserName = new JLabel();
        this.jLabel10 = new JLabel();
        this.cboProfiles = new JComboBox();
        this.lblVersion = new JLabel();
        this.cboVersions = new JComboBox();
        this.pnlPassword = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel9 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.jPanel3 = new JPanel();
        this.btnLogout = new JButton();
        this.btnImportModpack = new JButton();
        this.btnExportModpack = new JButton();
        this.setLayout(null);
        this.pnlMore.setBackground(new Color(204, 204, 204));
        this.pnlMore.setOpaque(false);
        this.txtPlayerName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainPagePanel.this.txtPlayerNameFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MainPagePanel.this.txtPlayerNameFocusLost(evt);
            }
        });
        this.txtPlayerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainPagePanel.this.txtPlayerNameKeyPressed(evt);
            }
        });
        this.jLabel7.setText(C.i18n("login.type", new Object[0]));
        this.cboLoginMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainPagePanel.this.cboLoginModeItemStateChanged(evt);
            }
        });
        this.lblUserName.setText(C.i18n("login.username", new Object[0]));
        this.jLabel10.setText(C.i18n("ui.label.profile", new Object[0]));
        this.cboProfiles.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainPagePanel.this.cboProfilesItemStateChanged(evt);
            }
        });
        this.lblVersion.setText(C.i18n("ui.label.version", new Object[0]));
        this.lblVersion.setToolTipText(C.i18n("ui.label.version", new Object[0]));
        this.cboVersions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainPagePanel.this.cboVersionsItemStateChanged(evt);
            }
        });
        this.pnlPassword.setLayout(new CardLayout());
        this.jLabel9.setText(C.i18n("ui.label.password", new Object[0]));
        this.txtPassword.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                MainPagePanel.this.txtPasswordCaretUpdate(evt);
            }
        });
        this.txtPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainPagePanel.this.txtPasswordFocusGained(evt);
            }
        });
        this.txtPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPagePanel.this.txtPasswordActionPerformed(evt);
            }
        });
        this.txtPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainPagePanel.this.txtPasswordKeyPressed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPassword)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9, -2, 22, -2).addComponent(this.txtPassword, -2, 26, -2))));
        this.pnlPassword.add((Component)this.jPanel1, "card2");
        this.btnLogout.setText(C.i18n("ui.button.logout", new Object[0]));
        this.btnLogout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPagePanel.this.btnLogoutActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLogout, -1, 170, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLogout, -1, -1, Short.MAX_VALUE));
        this.pnlPassword.add((Component)this.jPanel3, "card3");
        this.btnImportModpack.setText(C.i18n("modpack.task.install", new Object[0]));
        this.btnImportModpack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPagePanel.this.btnImportModpackActionPerformed(evt);
            }
        });
        this.btnExportModpack.setText(C.i18n("modpack.task.save", new Object[0]));
        this.btnExportModpack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPagePanel.this.btnExportModpackActionPerformed(evt);
            }
        });
        GroupLayout pnlMoreLayout = new GroupLayout(this.pnlMore);
        this.pnlMore.setLayout(pnlMoreLayout);
        pnlMoreLayout.setHorizontalGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMoreLayout.createSequentialGroup().addContainerGap().addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlPassword, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(pnlMoreLayout.createSequentialGroup().addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING).addComponent(this.lblVersion, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboProfiles, 0, 128, Short.MAX_VALUE).addComponent(this.cboVersions, 0, -1, Short.MAX_VALUE))).addGroup(pnlMoreLayout.createSequentialGroup().addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUserName).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboLoginMode, 0, -1, Short.MAX_VALUE).addComponent(this.txtPlayerName))).addComponent(this.btnExportModpack, -1, -1, Short.MAX_VALUE).addComponent(this.btnImportModpack, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlMoreLayout.setVerticalGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlMoreLayout.createSequentialGroup().addContainerGap().addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.cboProfiles, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboVersions, -2, 26, -2).addComponent(this.lblVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.cboLoginMode, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUserName).addComponent(this.txtPlayerName, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPassword, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 248, Short.MAX_VALUE).addComponent(this.btnImportModpack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExportModpack).addContainerGap()));
        this.add(this.pnlMore);
        this.pnlMore.setBounds(0, 0, 190, 480);
    }

    private void txtPlayerNameFocusGained(FocusEvent evt) {
        MainFrame.INSTANCE.closeMessage();
    }

    private void txtPlayerNameFocusLost(FocusEvent evt) {
        IAuthenticator l = Settings.getInstance().getAuthenticator();
        l.setUserName(this.txtPlayerName.getText());
    }

    private void cboLoginModeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (this.preparingAuth) {
            return;
        }
        Settings.getInstance().setLoginType(this.cboLoginMode.getSelectedIndex());
    }

    private void cboProfilesItemStateChanged(ItemEvent evt) {
        if (!this.isLoading && this.cboProfiles.getSelectedIndex() != -1 && !StrUtils.isBlank((String)this.cboProfiles.getSelectedItem())) {
            Settings.getInstance().setLast((String)this.cboProfiles.getSelectedItem());
        }
    }

    private void cboVersionsItemStateChanged(ItemEvent evt) {
        if (this.isLoading || evt.getStateChange() != 1 || this.cboVersions.getSelectedIndex() < 0 || StrUtils.isBlank((String)this.cboVersions.getSelectedItem())) {
            return;
        }
        String mcv = (String)this.cboVersions.getSelectedItem();
        Settings.getLastProfile().setSelectedMinecraftVersion(mcv);
    }

    private void txtPasswordFocusGained(FocusEvent evt) {
        MainFrame.INSTANCE.closeMessage();
    }

    private void txtPasswordActionPerformed(ActionEvent evt) {
        MainFrame.INSTANCE.daemon.runGame(Settings.getLastProfile());
    }

    private void btnLogoutActionPerformed(ActionEvent evt) {
        if (this.preparingAuth) {
            return;
        }
        IAuthenticator l = Settings.getInstance().getAuthenticator();
        CardLayout cl = (CardLayout)this.pnlPassword.getLayout();
        if (l.isLoggedIn()) {
            l.logOut();
        }
        cl.first(this.pnlPassword);
        SwingUtilities.invokeLater(MainPagePanel$$Lambda$9.lambdaFactory$(this));
    }

    private void txtPlayerNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            IAuthenticator l = Settings.getInstance().getAuthenticator();
            l.setUserName(this.txtPlayerName.getText());
            if (!l.hasPassword()) {
                MainFrame.INSTANCE.daemon.runGame(Settings.getLastProfile());
            } else if (!l.isLoggedIn()) {
                this.txtPassword.requestFocus();
            }
        }
    }

    private void txtPasswordKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            MainFrame.INSTANCE.daemon.runGame(Settings.getLastProfile());
        }
    }

    private void btnImportModpackActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(C.i18n("modpack.choose", new Object[0]));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileNameExtensionFilter(C.i18n("modpack", new Object[0]), "zip"));
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        String suggestedModpackId = JOptionPane.showInputDialog("Please enter your favourite game name", (Object)FileUtils.getBaseName(fc.getSelectedFile().getName()));
        TaskWindow.factory().append(ModpackManager.install(MainFrame.INSTANCE, fc.getSelectedFile(), Settings.getLastProfile().service(), suggestedModpackId)).create();
        Settings.getLastProfile().service().version().refreshVersions();
    }

    private void btnExportModpackActionPerformed(ActionEvent evt) {
        if (Settings.getLastProfile().service().version().getVersionCount() <= 0) {
            return;
        }
        WizardDisplayer.showWizard(new ModpackWizard(Settings.getLastProfile()).createWizard());
    }

    private void txtPasswordCaretUpdate(CaretEvent evt) {
        Settings.getInstance().getAuthenticator().setPassword(this.txtPassword.getText());
    }

    private void prepareAuths() {
        this.preparingAuth = true;
        this.cboLoginMode.removeAllItems();
        for (IAuthenticator str : IAuthenticator.LOGINS) {
            this.cboLoginMode.addItem(str.getName());
        }
        this.preparingAuth = false;
        int loginType = Settings.getInstance().getLoginType();
        if (0 <= loginType && loginType < this.cboLoginMode.getItemCount()) {
            this.cboLoginMode.setSelectedIndex(loginType);
            Settings.getInstance().setLoginType(loginType);
        }
    }

    @Override
    public void onCreate() {
        this.initGui();
        super.onCreate();
        Settings.onProfileLoading();
    }

    private void loadProfiles() {
        this.isLoading = true;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (Profile s : Settings.getProfilesFiltered()) {
            model.addElement(s.getName());
        }
        this.cboProfiles.setModel(model);
        this.isLoading = false;
    }

    void loadVersions() {
        this.isLoading = true;
        this.cboVersions.removeAllItems();
        String selVersion = Settings.getLastProfile().getSelectedVersion();
        if (Settings.getLastProfile().service().version().getVersions().isEmpty()) {
            if (!this.showedNoVersion && ((HMCLMinecraftService)Settings.getLastProfile().service()).checkedModpack) {
                this.showedNoVersion = true;
                SwingUtilities.invokeLater(MainPagePanel$$Lambda$10.lambdaFactory$());
            }
        } else {
            for (MinecraftVersion mcVersion : Settings.getLastProfile().service().version().getVersions()) {
                if (mcVersion.hidden) continue;
                this.cboVersions.addItem(mcVersion.id);
            }
            this.versionChanged.accept(selVersion);
        }
        this.isLoading = false;
    }

    void versionChanged(String selectedVersion) {
        this.isLoading = true;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboVersions.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(selectedVersion)) continue;
            model.setSelectedItem(selectedVersion);
            break;
        }
        this.cboVersions.setToolTipText(selectedVersion);
        this.isLoading = false;
    }

    private /* synthetic */ void lambda$new$50(Profile t) {
        t.service().version().onRefreshedVersions.register(this.onRefreshedVersions);
        t.selectedVersionChangedEvent.register(this.versionChanged);
        t.launcher().launchingStateChanged.register(this.launchingStateChanged);
        this.isLoading = true;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboProfiles.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(t.getName())) continue;
            model.setSelectedItem(t.getName());
            break;
        }
        this.isLoading = false;
    }

    private static /* synthetic */ void lambda$new$49(Boolean t) {
        SwingUtils.setEnabled(MainFrame.INSTANCE.getRootPane(), t == false);
    }

    private static /* synthetic */ void lambda$loadVersions$48() {
        if (MessageBox.Show(C.i18n("mainwindow.no_version", new Object[0]), 10) == 0) {
            MainFrame.INSTANCE.invokeAction("showGameDownloads");
        }
    }

    private /* synthetic */ void lambda$new$47(IMinecraftService t) {
        if (Settings.getLastProfile().service() == t) {
            this.loadVersions();
        }
    }

    private /* synthetic */ boolean lambda$new$46(Object sender, IAuthenticator l) {
        if (l.hasPassword()) {
            this.pnlPassword.setVisible(true);
            this.lblUserName.setText(C.i18n("login.account", new Object[0]));
        } else {
            this.pnlPassword.setVisible(false);
            this.lblUserName.setText(C.i18n("login.username", new Object[0]));
        }
        CardLayout cl = (CardLayout)this.pnlPassword.getLayout();
        if (l.isLoggedIn()) {
            cl.last(this.pnlPassword);
        } else {
            cl.first(this.pnlPassword);
        }
        String username = l.getUserName();
        if (username == null) {
            username = "";
        }
        this.txtPlayerName.setText(username);
        return true;
    }

    static /* synthetic */ boolean access$lambda$0(MainPagePanel mainPagePanel, Object object, IAuthenticator iAuthenticator) {
        return mainPagePanel.lambda$new$46(object, iAuthenticator);
    }

    static /* synthetic */ void access$lambda$1(MainPagePanel mainPagePanel) {
        mainPagePanel.loadProfiles();
    }

    static /* synthetic */ void access$lambda$2(MainPagePanel mainPagePanel, IMinecraftService iMinecraftService) {
        mainPagePanel.lambda$new$47(iMinecraftService);
    }

    static /* synthetic */ void access$lambda$3(Boolean bl) {
        MainPagePanel.lambda$new$49(bl);
    }

    static /* synthetic */ void access$lambda$4(MainPagePanel mainPagePanel, String string) {
        mainPagePanel.versionChanged(string);
    }

    static /* synthetic */ void access$lambda$5(MainPagePanel mainPagePanel, Profile profile) {
        mainPagePanel.lambda$new$50(profile);
    }

    static /* synthetic */ void access$lambda$6(ActionEvent actionEvent) {
        MainFrame.INSTANCE.daemon.runGame(Settings.getLastProfile());
    }

    static /* synthetic */ void access$lambda$7(MainPagePanel mainPagePanel) {
        mainPagePanel.prepareAuths();
    }

    static /* synthetic */ void access$lambda$8() {
        MainPagePanel.lambda$loadVersions$48();
    }
}

