/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadType;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.lang.SupportedLocales;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class LauncherSettingsPanel
extends AnimatedPanel {
    private JButton btnCheckUpdate;
    private JButton btnSelBackgroundPath;
    private JComboBox cboDownloadSource;
    private JComboBox cboLang;
    private JComboBox cboTheme;
    private JCheckBox chkDecorated;
    private JCheckBox chkEnableAnimation;
    private JCheckBox chkEnableShadow;
    private JLabel lblAbout;
    private JLabel lblBackground;
    private JLabel lblDownloadSource;
    private JLabel lblLang;
    private JLabel lblModpack;
    private JLabel lblProxy;
    private JLabel lblProxyHost;
    private JLabel lblProxyPassword;
    private JLabel lblProxyPort;
    private JLabel lblProxyUserName;
    private JLabel lblRestart;
    private JLabel lblTheme;
    private JTextField txtBackgroundPath;
    private JTextField txtProxyHost;
    private JTextField txtProxyPassword;
    private JTextField txtProxyPort;
    private JTextField txtProxyUsername;

    void initGui() {
        this.initComponents();
        DefaultComboBoxModel<String> d = new DefaultComboBoxModel<String>();
        for (DownloadType type : DownloadType.values()) {
            d.addElement(type.getName());
        }
        this.cboDownloadSource.setModel(d);
        d = new DefaultComboBoxModel();
        int id = 0;
        for (SupportedLocales type : SupportedLocales.values()) {
            d.addElement(type.showString());
            if (!type.name().equals(Settings.getInstance().getLocalization())) continue;
            id = type.ordinal();
        }
        this.cboLang.setModel(d);
        this.cboLang.setSelectedIndex(id);
        this.txtBackgroundPath.setText(Settings.getInstance().getBgpath());
        this.txtProxyHost.setText(Settings.getInstance().getProxyHost());
        this.txtProxyPort.setText(Settings.getInstance().getProxyPort());
        this.txtProxyUsername.setText(Settings.getInstance().getProxyUserName());
        this.txtProxyPassword.setText(Settings.getInstance().getProxyPassword());
        this.cboDownloadSource.setSelectedIndex(Settings.getInstance().getDownloadType());
        this.cboTheme.setSelectedIndex(Settings.getInstance().getTheme().ordinal());
        this.chkEnableShadow.setSelected(Settings.getInstance().isEnableShadow());
        this.chkEnableAnimation.setSelected(Settings.getInstance().isEnableAnimation());
        this.chkDecorated.setSelected(Settings.getInstance().isDecorated());
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    @Override
    public void onCreate() {
        this.initGui();
        super.onCreate();
    }

    private void initComponents() {
        this.cboDownloadSource = new JComboBox();
        this.lblAbout = new JLabel();
        this.btnSelBackgroundPath = new JButton();
        this.lblBackground = new JLabel();
        this.txtBackgroundPath = new JTextField();
        this.lblDownloadSource = new JLabel();
        this.btnCheckUpdate = new JButton();
        this.chkEnableShadow = new JCheckBox();
        this.lblTheme = new JLabel();
        this.cboTheme = new JComboBox();
        this.lblProxy = new JLabel();
        this.txtProxyHost = new JTextField();
        this.lblProxyHost = new JLabel();
        this.txtProxyPort = new JTextField();
        this.lblProxyPort = new JLabel();
        this.lblProxyUserName = new JLabel();
        this.txtProxyUsername = new JTextField();
        this.txtProxyPassword = new JTextField();
        this.lblProxyPassword = new JLabel();
        this.chkEnableAnimation = new JCheckBox();
        this.chkDecorated = new JCheckBox();
        this.lblModpack = new JLabel();
        this.cboLang = new JComboBox();
        this.lblLang = new JLabel();
        this.lblRestart = new JLabel();
        this.cboDownloadSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.cboDownloadSourceItemStateChanged(evt);
            }
        });
        this.lblAbout.setText(C.i18n("launcher.about", new Object[0]));
        this.lblAbout.setCursor(new Cursor(12));
        this.lblAbout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LauncherSettingsPanel.this.lblAboutMouseClicked(evt);
            }
        });
        this.btnSelBackgroundPath.setText(C.i18n("ui.button.explore", new Object[0]));
        this.btnSelBackgroundPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LauncherSettingsPanel.this.btnSelBackgroundPathActionPerformed(evt);
            }
        });
        this.lblBackground.setText(C.i18n("launcher.background_location", new Object[0]));
        this.lblBackground.setToolTipText("");
        this.txtBackgroundPath.setToolTipText(C.i18n("launcher.background_tooltip", new Object[0]));
        this.txtBackgroundPath.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LauncherSettingsPanel.this.txtBackgroundPathFocusLost(evt);
            }
        });
        this.lblDownloadSource.setText(C.i18n("launcher.download_source", new Object[0]));
        this.btnCheckUpdate.setText(C.i18n("launcher.update_launcher", new Object[0]));
        this.btnCheckUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LauncherSettingsPanel.this.btnCheckUpdateActionPerformed(evt);
            }
        });
        this.chkEnableShadow.setText(C.i18n("launcher.enable_shadow", new Object[0]));
        this.chkEnableShadow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.chkEnableShadowItemStateChanged(evt);
            }
        });
        this.lblTheme.setText(C.i18n("launcher.theme", new Object[0]));
        this.cboTheme.setModel(new DefaultComboBoxModel<String>(new String[]{C.i18n("color.blue", new Object[0]), C.i18n("color.green", new Object[0]), C.i18n("color.purple", new Object[0]), C.i18n("color.dark_blue", new Object[0]), C.i18n("color.orange", new Object[0]), C.i18n("color.red", new Object[0])}));
        this.cboTheme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.cboThemeItemStateChanged(evt);
            }
        });
        this.lblProxy.setText(C.i18n("launcher.proxy", new Object[0]));
        this.txtProxyHost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LauncherSettingsPanel.this.txtProxyHostFocusLost(evt);
            }
        });
        this.lblProxyHost.setText(C.i18n("proxy.host", new Object[0]));
        this.txtProxyPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LauncherSettingsPanel.this.txtProxyPortFocusLost(evt);
            }
        });
        this.lblProxyPort.setText(C.i18n("proxy.port", new Object[0]));
        this.lblProxyUserName.setText(C.i18n("proxy.username", new Object[0]));
        this.txtProxyUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LauncherSettingsPanel.this.txtProxyUsernameFocusLost(evt);
            }
        });
        this.txtProxyPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LauncherSettingsPanel.this.txtProxyPasswordFocusLost(evt);
            }
        });
        this.lblProxyPassword.setText(C.i18n("proxy.password", new Object[0]));
        this.chkEnableAnimation.setText(C.i18n("launcher.enable_animation", new Object[0]));
        this.chkEnableAnimation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.chkEnableAnimationItemStateChanged(evt);
            }
        });
        this.chkDecorated.setText(C.i18n("launcher.decorated", new Object[0]));
        this.chkDecorated.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.chkDecoratedItemStateChanged(evt);
            }
        });
        this.lblModpack.setText(C.i18n("launcher.modpack", new Object[0]));
        this.lblModpack.setCursor(new Cursor(12));
        this.lblModpack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LauncherSettingsPanel.this.lblModpackMouseClicked(evt);
            }
        });
        this.cboLang.setModel(new DefaultComboBoxModel<String>(new String[]{C.i18n("color.blue", new Object[0]), C.i18n("color.green", new Object[0]), C.i18n("color.purple", new Object[0]), C.i18n("color.dark_blue", new Object[0]), C.i18n("color.orange", new Object[0]), C.i18n("color.red", new Object[0])}));
        this.cboLang.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LauncherSettingsPanel.this.cboLangItemStateChanged(evt);
            }
        });
        this.lblLang.setText(C.i18n("launcher.lang", new Object[0]));
        this.lblRestart.setText(C.i18n("launcher.restart", new Object[0]));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.chkEnableShadow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.chkEnableAnimation)).addGroup(layout.createSequentialGroup().addComponent(this.btnCheckUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.chkDecorated)).addGroup(layout.createSequentialGroup().addComponent(this.lblProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblProxyHost).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtProxyHost, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblProxyPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtProxyPort, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblProxyUserName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtProxyUsername, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblProxyPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtProxyPassword, -2, 80, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDownloadSource).addComponent(this.lblTheme).addComponent(this.lblBackground).addComponent(this.lblLang)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboLang, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txtBackgroundPath, -1, 664, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelBackgroundPath)).addComponent(this.cboDownloadSource, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.cboTheme, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAbout, -2, -1, -2).addComponent(this.lblModpack, -2, -1, -2).addComponent(this.lblRestart)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBackground).addComponent(this.btnSelBackgroundPath, -2, 26, -2).addComponent(this.txtBackgroundPath, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDownloadSource).addComponent(this.cboDownloadSource, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTheme).addComponent(this.cboTheme, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLang).addComponent(this.cboLang, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtProxyHost, -2, 26, -2).addComponent(this.lblProxy).addComponent(this.lblProxyHost).addComponent(this.txtProxyPort, -2, 26, -2).addComponent(this.lblProxyPort).addComponent(this.txtProxyUsername, -2, 26, -2).addComponent(this.lblProxyUserName).addComponent(this.txtProxyPassword, -2, 26, -2).addComponent(this.lblProxyPassword)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkEnableShadow).addComponent(this.chkEnableAnimation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCheckUpdate, -2, 26, -2).addComponent(this.chkDecorated)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblRestart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addComponent(this.lblModpack, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAbout, -2, -1, -2).addContainerGap()));
    }

    private void cboDownloadSourceItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setDownloadType(this.cboDownloadSource.getSelectedIndex());
    }

    private void btnSelBackgroundPathActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(C.i18n("launcher.choose_bgpath", new Object[0]));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileNameExtensionFilter("*.png", "png"));
        fc.addChoosableFileFilter(new FileNameExtensionFilter("*.jpg", "jpg"));
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        try {
            String path = fc.getSelectedFile().getCanonicalPath();
            path = IOUtils.removeLastSeparator(path);
            this.txtBackgroundPath.setText(path);
            Settings.getInstance().setBgpath(path);
            MainFrame.INSTANCE.loadBackground();
        }
        catch (IOException e) {
            HMCLog.warn("Failed to set background path.", e);
            MessageBox.Show(C.i18n("ui.label.failed_set", new Object[0]) + e.getMessage());
        }
    }

    private void txtBackgroundPathFocusLost(FocusEvent evt) {
        Settings.getInstance().setBgpath(this.txtBackgroundPath.getText());
        MainFrame.INSTANCE.loadBackground();
    }

    private void btnCheckUpdateActionPerformed(ActionEvent evt) {
        Settings.UPDATE_CHECKER.process(true);
        Settings.UPDATE_CHECKER.checkOutdate();
    }

    private void cboThemeItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setTheme(this.cboTheme.getSelectedIndex());
    }

    private void lblModpackMouseClicked(MouseEvent evt) {
        SwingUtils.openLink("http://huangyuhui.duapp.com/link.php?type=modpack");
    }

    private void cboLangItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setLocalization(SupportedLocales.values()[this.cboLang.getSelectedIndex()].name());
    }

    private void chkEnableShadowItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setEnableShadow(this.chkEnableShadow.isSelected());
    }

    private void chkDecoratedItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setDecorated(this.chkDecorated.isSelected());
    }

    private void chkEnableAnimationItemStateChanged(ItemEvent evt) {
        Settings.getInstance().setEnableAnimation(this.chkEnableAnimation.isSelected());
    }

    private void txtProxyHostFocusLost(FocusEvent evt) {
        Settings.getInstance().setProxyHost(this.txtProxyHost.getText());
    }

    private void txtProxyPortFocusLost(FocusEvent evt) {
        Settings.getInstance().setProxyPort(this.txtProxyPort.getText());
    }

    private void txtProxyUsernameFocusLost(FocusEvent evt) {
        Settings.getInstance().setProxyUserName(this.txtProxyUsername.getText());
    }

    private void txtProxyPasswordFocusLost(FocusEvent evt) {
        Settings.getInstance().setProxyPassword(this.txtProxyPassword.getText());
    }

    private void lblAboutMouseClicked(MouseEvent evt) {
        SwingUtils.openLink("http://huangyuhui.duapp.com/link.php?type=sponsor");
    }
}

