/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerType;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel;
import org.jackhuang.hellominecraft.launcher.ui.InstallerPanel$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.InstallerPanel$$Lambda$2;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskRunnable;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class InstallerPanel
extends AnimatedPanel {
    GameSettingsPanel gsp;
    transient List<InstallerVersionList.InstallerVersion> versions;
    transient InstallerVersionList list;
    InstallerType id;
    boolean refreshed = false;
    private JButton btnInstall;
    private JButton btnRefresh;
    private JScrollPane jScrollPane12;
    private JTable lstInstallers;

    public InstallerPanel(GameSettingsPanel gsp, InstallerType installerType) {
        this.initComponents();
        this.setOpaque(false);
        this.gsp = gsp;
        this.id = installerType;
        this.list = Settings.getInstance().getDownloadSource().getProvider().getInstallerByType(this.id);
    }

    private void initComponents() {
        this.btnInstall = new JButton();
        this.jScrollPane12 = new JScrollPane();
        this.lstInstallers = new JTable();
        this.btnRefresh = new JButton();
        this.btnInstall.setText(C.i18n("ui.button.install", new Object[0]));
        this.btnInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerPanel.this.btnInstallActionPerformed(evt);
            }
        });
        this.lstInstallers.setModel(SwingUtils.makeDefaultTableModel(new String[]{C.i18n("install.version", new Object[0]), C.i18n("install.mcversion", new Object[0])}, new Class[]{String.class, String.class}, new boolean[]{false, false}));
        this.lstInstallers.setSelectionMode(0);
        this.jScrollPane12.setViewportView(this.lstInstallers);
        this.btnRefresh.setText(C.i18n("ui.button.refresh", new Object[0]));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerPanel.this.btnRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane12, -1, 292, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRefresh, -1, -1, Short.MAX_VALUE).addComponent(this.btnInstall, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane12, -1, 147, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnInstall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void btnInstallActionPerformed(ActionEvent evt) {
        this.downloadSelectedRow();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.refreshVersions();
    }

    void refreshVersions() {
        if (TaskWindow.execute(this.list.refresh(new String[]{this.gsp.getMinecraftVersionFormatted()}))) {
            this.loadVersions();
        }
    }

    public synchronized InstallerVersionList.InstallerVersion getVersion(int idx) {
        return this.versions.get(idx);
    }

    synchronized void downloadSelectedRow() {
        int idx = this.lstInstallers.getSelectedRow();
        if (this.versions == null || idx < 0 || idx >= this.versions.size()) {
            MessageBox.Show(C.i18n("install.not_refreshed", new Object[0]));
            return;
        }
        TaskWindow.execute(Settings.getLastProfile().service().install().download(Settings.getLastProfile().getSelectedVersion(), this.getVersion(idx), this.id), new TaskRunnable(InstallerPanel$$Lambda$1.lambdaFactory$(this)));
    }

    public void loadVersions() {
        SwingUtilities.invokeLater(InstallerPanel$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    public void onSelect() {
        if (!this.refreshed) {
            this.refreshVersions();
            this.refreshed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$loadVersions$28() {
        InstallerPanel installerPanel = this;
        synchronized (installerPanel) {
            DefaultTableModel model = (DefaultTableModel)this.lstInstallers.getModel();
            String mcver = StrUtils.formatVersion(this.gsp.getMinecraftVersionFormatted());
            this.versions = this.list.getVersions(mcver);
            SwingUtils.clearDefaultTable(this.lstInstallers);
            if (this.versions != null) {
                for (InstallerVersionList.InstallerVersion v : this.versions) {
                    if (v == null) continue;
                    model.addRow(new Object[]{v.selfVersion == null ? "null" : v.selfVersion, v.mcVersion == null ? "null" : v.mcVersion});
                }
            }
        }
    }

    static /* synthetic */ void access$lambda$0(InstallerPanel installerPanel) {
        installerPanel.refreshVersions();
    }

    static /* synthetic */ void access$lambda$1(InstallerPanel installerPanel) {
        installerPanel.lambda$loadVersions$28();
    }
}

