/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.jackhuang.hellominecraft.launcher.core.download.MinecraftRemoteVersion;
import org.jackhuang.hellominecraft.launcher.core.download.MinecraftRemoteVersions;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.GameDownloadPanel$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.GameDownloadPanel$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.OverridableSwingWorker;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class GameDownloadPanel
extends AnimatedPanel {
    GameSettingsPanel gsp;
    private JButton btnDownload;
    private JButton btnRefreshGameDownloads;
    private JScrollPane jScrollPane2;
    private JTable lstDownloads;
    boolean refreshedDownloads = false;

    public GameDownloadPanel(GameSettingsPanel gsp) {
        this.initComponents();
        this.gsp = gsp;
    }

    private void initComponents() {
        this.btnDownload = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.lstDownloads = new JTable();
        this.btnRefreshGameDownloads = new JButton();
        this.btnDownload.setText(C.i18n("ui.button.download", new Object[0]));
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameDownloadPanel.this.btnDownloadActionPerformed(evt);
            }
        });
        this.lstDownloads.setModel(SwingUtils.makeDefaultTableModel(new String[]{C.i18n("install.version", new Object[0]), C.i18n("install.time", new Object[0]), C.i18n("install.type", new Object[0])}, new Class[]{String.class, String.class, String.class}, new boolean[]{false, false, false}));
        this.lstDownloads.setToolTipText("");
        this.lstDownloads.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lstDownloads);
        this.btnRefreshGameDownloads.setText(C.i18n("ui.button.refresh", new Object[0]));
        this.btnRefreshGameDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameDownloadPanel.this.btnRefreshGameDownloadsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 350, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDownload, -1, -1, Short.MAX_VALUE).addComponent(this.btnRefreshGameDownloads, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnRefreshGameDownloads).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDownload)).addComponent(this.jScrollPane2, -1, 300, Short.MAX_VALUE));
    }

    private void btnDownloadActionPerformed(ActionEvent evt) {
        this.downloadMinecraft();
        this.gsp.refreshVersions();
    }

    private void btnRefreshGameDownloadsActionPerformed(ActionEvent evt) {
        this.refreshDownloads();
    }

    public void refreshDownloads() {
        DefaultTableModel model = SwingUtils.clearDefaultTable(this.lstDownloads);
        OverridableSwingWorker overridableSwingWorker = MinecraftRemoteVersions.refreshRomoteVersions(Settings.getLastProfile().service().getDownloadType()).reg(GameDownloadPanel$$Lambda$1.lambdaFactory$(model));
        JTable jTable = this.lstDownloads;
        jTable.getClass();
        overridableSwingWorker.regDone(GameDownloadPanel$$Lambda$2.lambdaFactory$(jTable)).execute();
    }

    void downloadMinecraft() {
        if (this.lstDownloads.getSelectedRow() < 0) {
            MessageBox.Show(C.i18n("gamedownload.not_refreshed", new Object[0]));
            return;
        }
        String id = (String)this.lstDownloads.getModel().getValueAt(this.lstDownloads.getSelectedRow(), 0);
        TaskWindow.execute(Settings.getLastProfile().service().download().downloadMinecraft(id));
    }

    @Override
    public void onSelect() {
        super.onSelect();
        if (!this.refreshedDownloads) {
            this.refreshedDownloads = true;
            this.refreshDownloads();
        }
    }

    static /* synthetic */ void access$lambda$0(DefaultTableModel defaultTableModel, MinecraftRemoteVersion minecraftRemoteVersion) {
        defaultTableModel.addRow(new Object[]{minecraftRemoteVersion.id, minecraftRemoteVersion.time, StrUtils.equalsOne(minecraftRemoteVersion.type, "old_beta", "old_alpha", "release", "snapshot") ? C.i18n("versions." + minecraftRemoteVersion.type, new Object[0]) : minecraftRemoteVersion.type});
    }
}

