/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel$$Lambda$4;
import org.jackhuang.hellominecraft.launcher.ui.Selectable;

public class AnimatedPanel
extends JPanel
implements Selectable {
    private static final int ANIMATION_LENGTH = 10;
    double offsetX = 10.0;
    Timer timer = new Timer(1, AnimatedPanel$$Lambda$1.lambdaFactory$(this));
    boolean animationEnabled = true;
    boolean selected = false;
    boolean created = false;

    public void animate() {
        if (Settings.getInstance().isEnableAnimation() && this.animationEnabled) {
            this.offsetX = 0.0;
            this.timer.start();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            super.paint(g);
            return;
        }
        double pgs = 1.0 - Math.sin(0.15707963267948966 * this.offsetX);
        if (Math.abs(10.0 - this.offsetX) < 0.1) {
            super.paint(g);
            return;
        }
        if (pgs > 1.0) {
            pgs = 1.0;
        }
        if (pgs < 0.0) {
            pgs = 0.0;
        }
        Graphics2D gg = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.translate((int)(pgs * 50.0), 0);
        super.paint(g2d);
        g2d.dispose();
        gg.setComposite(AlphaComposite.getInstance(10, (float)(1.0 - pgs)));
        g.drawImage(image, 0, 0, this);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void onSelect() {
        if (!this.selected) {
            this.animate();
        }
        this.selected = true;
    }

    @Override
    public void onLeave() {
        this.selected = false;
    }

    @Override
    public void onCreate() {
        this.created = true;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    private /* synthetic */ void lambda$new$15(ActionEvent e) {
        SwingUtilities.invokeLater(AnimatedPanel$$Lambda$4.lambdaFactory$(this));
    }

    private /* synthetic */ void lambda$null$14() {
        this.repaint();
        this.offsetX += 0.15;
        if (this.offsetX >= 10.0) {
            this.timer.stop();
            this.repaint();
        }
    }

    static /* synthetic */ void access$lambda$0(AnimatedPanel animatedPanel, ActionEvent actionEvent) {
        animatedPanel.lambda$new$15(actionEvent);
    }

    static /* synthetic */ void access$lambda$1(AnimatedPanel animatedPanel) {
        animatedPanel.lambda$null$14();
    }
}

