/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.setting;

import java.io.File;
import org.jackhuang.hellominecraft.launcher.api.PluginManager;
import org.jackhuang.hellominecraft.launcher.core.MCUtils;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.launcher.setting.Profile$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.setting.VersionSetting;
import org.jackhuang.hellominecraft.launcher.util.HMCLGameLauncher;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.OS;

public final class Profile {
    private String name;
    private String selectedMinecraftVersion = "";
    private String gameDir;
    private transient IMinecraftService service;
    private transient HMCLGameLauncher launcher = new HMCLGameLauncher(this);
    public final transient EventHandler<String> propertyChanged = new EventHandler(this);
    private final transient VersionSetting defaultVersionSetting = new VersionSetting();
    public final transient EventHandler<String> selectedVersionChangedEvent = new EventHandler(this);

    public Profile() {
        this("Default");
    }

    public Profile(String name) {
        this(name, new File(".minecraft").getPath());
    }

    public Profile(String name, String gameDir) {
        this.name = name;
        this.gameDir = gameDir;
    }

    public Profile(String name, Profile v) {
        this();
        if (v == null) {
            return;
        }
        this.name = name;
        this.gameDir = v.gameDir;
    }

    public IMinecraftService service() {
        if (this.service == null) {
            this.service = PluginManager.plugin().provideMinecraftService(this);
        }
        return this.service;
    }

    public HMCLGameLauncher launcher() {
        return this.launcher;
    }

    public VersionSetting getSelectedVersionSetting() {
        VersionSetting vs = this.getVersionSetting(this.getSelectedVersion());
        if (vs == null) {
            vs = this.defaultVersionSetting;
        }
        return vs;
    }

    public VersionSetting getVersionSetting(String id) {
        return ((HMCLMinecraftService)this.service()).getVersionSetting(id);
    }

    public String getSettingsSelectedMinecraftVersion() {
        return this.selectedMinecraftVersion;
    }

    public String getSelectedVersion() {
        String v = this.selectedMinecraftVersion;
        if (StrUtils.isBlank(v) || this.service().version().getVersionById(v) == null || this.service().version().getVersionById((String)v).hidden) {
            MinecraftVersion mv = this.service().version().getOneVersion(Profile$$Lambda$1.lambdaFactory$());
            if (mv != null) {
                v = mv.id;
            }
            if (StrUtils.isNotBlank(v)) {
                this.setSelectedMinecraftVersion(v);
            }
        }
        return StrUtils.isBlank(v) ? null : v;
    }

    public void setSelectedMinecraftVersion(String selectedMinecraftVersion) {
        this.selectedMinecraftVersion = selectedMinecraftVersion;
        this.propertyChanged.execute("selectedMinecraftVersion");
        this.selectedVersionChangedEvent.execute(selectedMinecraftVersion);
    }

    public String getGameDir() {
        if (StrUtils.isBlank(this.gameDir)) {
            this.gameDir = MCUtils.getInitGameDir().getPath();
        }
        return IOUtils.addSeparator(this.gameDir);
    }

    public String getCanonicalGameDir() {
        return IOUtils.tryGetCanonicalFolderPath(this.getGameDirFile());
    }

    public File getCanonicalGameDirFile() {
        return IOUtils.tryGetCanonicalFile(this.getGameDirFile());
    }

    public File getGameDirFile() {
        return new File(this.getGameDir());
    }

    public Profile setGameDir(String gameDir) {
        this.gameDir = gameDir;
        this.service().version().refreshVersions();
        this.propertyChanged.execute("gameDir");
        return this;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
        this.propertyChanged.execute("name");
    }

    public void checkFormat() {
        this.gameDir = this.gameDir.replace('/', OS.os().fileSeparator).replace('\\', OS.os().fileSeparator);
    }

    public void onSelected() {
        this.service().version().refreshVersions();
    }

    private static /* synthetic */ boolean lambda$getSelectedVersion$2(MinecraftVersion t) {
        return !t.hidden;
    }

    static /* synthetic */ boolean access$lambda$0(MinecraftVersion minecraftVersion) {
        return Profile.lambda$getSelectedVersion$2(minecraftVersion);
    }
}

