/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.setting;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadType;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.lookandfeel.Theme;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.system.JdkVersion;
import org.jackhuang.hellominecraft.util.system.OS;

public final class Config
implements Cloneable {
    @SerializedName(value="last")
    private String last;
    @SerializedName(value="bgpath")
    private String bgpath;
    @SerializedName(value="clientToken")
    private final String clientToken;
    private String proxyHost;
    private String proxyPort;
    private String proxyUserName;
    private String proxyPassword;
    @SerializedName(value="enableShadow")
    private boolean enableShadow = false;
    @SerializedName(value="decorated")
    private boolean decorated;
    @SerializedName(value="enableAnimation")
    private boolean enableAnimation = true;
    @SerializedName(value="theme")
    private int theme = 4;
    @SerializedName(value="java")
    private List<JdkVersion> java;
    @SerializedName(value="localization")
    private String localization;
    @SerializedName(value="logintype")
    private int logintype = 0;
    @SerializedName(value="downloadtype")
    private int downloadtype = 0;
    @SerializedName(value="configurations")
    private TreeMap<String, Profile> configurations;
    @SerializedName(value="auth")
    private Map<String, Map> auth;
    public final transient EventHandler<Theme> themeChangedEvent = new EventHandler(this);
    public final transient EventHandler<DownloadType> downloadTypeChangedEvent = new EventHandler(this);
    public final transient EventHandler<IAuthenticator> authChangedEvent = new EventHandler(this);

    public List<JdkVersion> getJava() {
        return this.java == null ? (this.java = new ArrayList<JdkVersion>()) : this.java;
    }

    public Theme getTheme() {
        if (this.theme >= Theme.values().length) {
            this.theme = 0;
        }
        return Theme.values()[this.theme];
    }

    public void setTheme(int theme) {
        this.theme = theme;
        this.themeChangedEvent.execute(this.getTheme());
        Settings.save();
    }

    public boolean isDecorated() {
        return this.decorated;
    }

    public void setDecorated(boolean decorated) {
        this.decorated = decorated;
    }

    public boolean isEnableShadow() {
        return this.enableShadow;
    }

    public void setEnableShadow(boolean enableShadow) {
        this.enableShadow = enableShadow;
        Settings.save();
    }

    public String getLast() {
        if (this.last == null) {
            this.last = "Default";
        }
        return this.last;
    }

    public void setLast(String last) {
        this.last = last;
        Settings.onProfileChanged();
        Settings.save();
    }

    public String getBgpath() {
        return this.bgpath;
    }

    public void setBgpath(String bgpath) {
        this.bgpath = bgpath;
        Settings.save();
    }

    public boolean isEnableAnimation() {
        return this.enableAnimation;
    }

    public void setEnableAnimation(boolean enableAnimation) {
        this.enableAnimation = enableAnimation;
        Settings.save();
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public IAuthenticator getAuthenticator() {
        return IAuthenticator.LOGINS.get(this.getLoginType());
    }

    public int getLoginType() {
        if (this.logintype < 0 || this.logintype >= IAuthenticator.LOGINS.size()) {
            this.logintype = 0;
        }
        return this.logintype;
    }

    public void setLoginType(int logintype) {
        if (logintype < 0 || logintype >= IAuthenticator.LOGINS.size()) {
            return;
        }
        this.logintype = logintype;
        this.authChangedEvent.execute(IAuthenticator.LOGINS.get(logintype));
        Settings.save();
    }

    public int getDownloadType() {
        return this.downloadtype;
    }

    public void setDownloadType(int downloadtype) {
        this.downloadtype = downloadtype;
        this.downloadTypeChangedEvent.execute(this.getDownloadSource());
        Settings.save();
    }

    public TreeMap<String, Profile> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new TreeMap();
        }
        if (this.configurations.isEmpty()) {
            Profile profile = new Profile();
            this.configurations.put(profile.getName(), profile);
        }
        return this.configurations;
    }

    public Map getAuthenticatorConfig(String authId) {
        return this.auth.get(authId);
    }

    public void setAuthenticatorConfig(String authId, Map map) {
        this.auth.put(authId, map);
        Settings.save();
    }

    public Config() {
        this.clientToken = UUID.randomUUID().toString();
        this.decorated = OS.os() == OS.LINUX;
        this.auth = new HashMap<String, Map>();
    }

    public DownloadType getDownloadSource() {
        if (this.downloadtype >= DownloadType.values().length || this.downloadtype < 0) {
            this.downloadtype = 0;
            Settings.save();
        }
        return DownloadType.values()[this.downloadtype];
    }

    public String getProxyHost() {
        return this.proxyHost == null ? "" : this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        Settings.save();
    }

    public String getProxyPort() {
        return this.proxyPort == null ? "" : this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
        Settings.save();
    }

    public String getProxyUserName() {
        return this.proxyUserName == null ? "" : this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
        Settings.save();
    }

    public String getProxyPassword() {
        return this.proxyPassword == null ? "" : this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        Settings.save();
    }

    public String getLocalization() {
        return this.localization;
    }

    public void setLocalization(String localization) {
        this.localization = localization;
        Settings.save();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

