/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.version;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.jackhuang.hellominecraft.launcher.core.version.Extract;
import org.jackhuang.hellominecraft.launcher.core.version.IMinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.LibrariesDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.LibraryDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.Natives;
import org.jackhuang.hellominecraft.launcher.core.version.Rules;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.system.Platform;

public class MinecraftLibrary
extends IMinecraftLibrary {
    public ArrayList<Rules> rules;
    public String url;
    public Natives natives;
    public Extract extract;
    public LibrariesDownloadInfo downloads;

    public MinecraftLibrary(String name) {
        super(name);
    }

    public MinecraftLibrary(ArrayList<Rules> rules, String url, Natives natives, String name, Extract extract, LibraryDownloadInfo downloads) {
        super(name);
        this.rules = rules == null ? null : (ArrayList)rules.clone();
        this.url = url;
        this.natives = natives == null ? null : (Natives)natives.clone();
        this.extract = extract == null ? null : (Extract)extract.clone();
    }

    @Override
    public boolean allow() {
        if (this.rules != null) {
            boolean flag = false;
            for (Rules r : this.rules) {
                if ("disallow".equals(r.action())) {
                    return false;
                }
                if (!"allow".equals(r.action())) continue;
                flag = true;
            }
            return flag;
        }
        return true;
    }

    private String formatArch(String nati) {
        return nati == null ? "" : nati.replace("${arch}", Platform.getPlatform().getBit());
    }

    private String getNative() {
        switch (OS.os()) {
            case WINDOWS: {
                return this.formatArch(this.natives.windows);
            }
            case OSX: {
                return this.formatArch(this.natives.osx);
            }
        }
        return this.formatArch(this.natives.linux);
    }

    @Override
    public boolean isRequiredToUnzip() {
        return this.natives != null && this.allow();
    }

    public String formatName() {
        String[] s = this.name.split(":");
        if (s.length < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s[0].replace('.', '/')).append('/').append(s[1]).append('/').append(s[2]).append('/').append(s[1]).append('-').append(s[2]);
        if (this.natives != null) {
            sb.append('-').append(this.getNative());
        }
        return sb.append(".jar").toString();
    }

    @Override
    public File getFilePath(File gameDir) {
        return new File(gameDir, "libraries/" + this.getDownloadInfo().path);
    }

    @Override
    public Extract getDecompressExtractRules() {
        return this.extract == null ? new Extract() : this.extract;
    }

    @Override
    public LibraryDownloadInfo getDownloadInfo() {
        LibraryDownloadInfo info;
        if (this.downloads == null) {
            this.downloads = new LibrariesDownloadInfo();
        }
        if (this.natives != null) {
            if (this.downloads.classifiers == null) {
                this.downloads.classifiers = new HashMap<String, LibraryDownloadInfo>();
            }
            if (!this.downloads.classifiers.containsKey(this.getNative())) {
                info = new LibraryDownloadInfo();
                this.downloads.classifiers.put(this.getNative(), info);
            } else {
                info = this.downloads.classifiers.get(this.getNative());
            }
        } else if (this.downloads.artifact == null) {
            this.downloads.artifact = info = new LibraryDownloadInfo();
        } else {
            info = this.downloads.artifact;
        }
        if (StrUtils.isBlank(info.path)) {
            info.path = this.formatName();
            if (info.path == null) {
                return null;
            }
        }
        info.forgeURL = this.url;
        return info;
    }
}

